/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.proxy.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import org.apache.jmeter.gui.action.KeyStrokes;
import org.apache.jmeter.protocol.http.proxy.gui.ProxyControlGui;
import org.apache.jmeter.util.JMeterUtils;

public class RecorderDialog
extends JDialog
implements ItemListener,
KeyListener,
ActionListener {
    private static final long serialVersionUID = 931790497924069705L;
    private JTextField prefixHTTPSampleName;
    private JTextField proxyPauseHTTPSample;
    private JComboBox<String> httpSampleNamingMode;
    private ProxyControlGui recorderGui;
    private JButton stop;

    public RecorderDialog() {
    }

    public RecorderDialog(ProxyControlGui controlGui) {
        super((Frame)null, JMeterUtils.getResString((String)"proxy_recorder_dialog"), false);
        this.recorderGui = controlGui;
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        this.init();
    }

    @Override
    protected JRootPane createRootPane() {
        JRootPane rootPane = new JRootPane();
        AbstractAction escapeAction = new AbstractAction("ESCAPE"){
            private static final long serialVersionUID = -6543764044868772971L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RecorderDialog.this.setVisible(false);
            }
        };
        ActionMap actionMap = rootPane.getActionMap();
        actionMap.put(escapeAction.getValue("Name"), escapeAction);
        InputMap inputMap = rootPane.getInputMap(2);
        inputMap.put(KeyStrokes.ESC, escapeAction.getValue("Name"));
        return rootPane;
    }

    private void init() {
        this.getContentPane().setLayout(new BorderLayout(10, 10));
        DefaultComboBoxModel<String> choice = new DefaultComboBoxModel<String>();
        choice.addElement(JMeterUtils.getResString((String)"sample_name_prefix"));
        choice.addElement(JMeterUtils.getResString((String)"sample_name_transaction"));
        this.httpSampleNamingMode = new JComboBox(choice);
        this.httpSampleNamingMode.setName("proxy_http_sampler_naming_mode");
        this.httpSampleNamingMode.addItemListener(this);
        this.prefixHTTPSampleName = new JTextField(20);
        this.prefixHTTPSampleName.addKeyListener(this);
        this.prefixHTTPSampleName.setName("proxy_prefix_http_sampler_name");
        this.proxyPauseHTTPSample = new JTextField(10);
        this.proxyPauseHTTPSample.addKeyListener(this);
        this.proxyPauseHTTPSample.setName("proxy_pause_http_sampler");
        this.proxyPauseHTTPSample.setActionCommand("enable_restart");
        JLabel labelProxyPause = new JLabel(JMeterUtils.getResString((String)"proxy_pause_http_sampler"));
        labelProxyPause.setLabelFor(this.proxyPauseHTTPSample);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 23;
        gbc.fill = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        JPanel panel = new JPanel(gridBagLayout);
        panel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"proxy_sampler_settings")));
        panel.add(this.httpSampleNamingMode, gbc.clone());
        ++gbc.gridx;
        gbc.weightx = 3.0;
        gbc.fill = 2;
        panel.add((Component)this.prefixHTTPSampleName, gbc.clone());
        gbc.gridx = 0;
        ++gbc.gridy;
        panel.add((Component)labelProxyPause, gbc.clone());
        ++gbc.gridx;
        gbc.weightx = 3.0;
        gbc.fill = 2;
        panel.add((Component)this.proxyPauseHTTPSample, gbc.clone());
        this.getContentPane().add((Component)panel, "Center");
        String iconSize = JMeterUtils.getPropDefault((String)"jmeter.toolbar.icons.size", (String)"22x22");
        this.stop = this.recorderGui.createStopButton(iconSize);
        this.stop.addActionListener(this);
        GridLayout gridLayout = new GridLayout(1, 1);
        JPanel panelStop = new JPanel(gridLayout);
        panelStop.add(this.stop);
        this.getContentPane().add((Component)panelStop, "West");
        this.pack();
        this.setLocation(5, 10);
        this.prefixHTTPSampleName.requestFocusInWindow();
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        this.stop.setEnabled(true);
        this.prefixHTTPSampleName.requestFocusInWindow();
        this.prefixHTTPSampleName.setText(this.recorderGui.getPrefixHTTPSampleName());
        this.httpSampleNamingMode.setSelectedIndex(this.recorderGui.getHTTPSampleNamingMode());
        this.proxyPauseHTTPSample.setText(this.recorderGui.getProxyPauseHTTPSample());
        this.setAlwaysOnTop(b);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() instanceof JComboBox) {
            JComboBox combo = (JComboBox)e.getSource();
            if ("proxy_http_sampler_naming_mode".equals(combo.getName())) {
                this.recorderGui.setHTTPSampleNamingMode(this.httpSampleNamingMode.getSelectedIndex());
            }
        } else {
            this.recorderGui.enableRestart();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        String fieldName = e.getComponent().getName();
        if (fieldName.equals("proxy_prefix_http_sampler_name")) {
            this.recorderGui.setPrefixHTTPSampleName(this.prefixHTTPSampleName.getText());
        } else if (fieldName.equals("proxy_pause_http_sampler")) {
            block5: {
                try {
                    Long.parseLong(this.proxyPauseHTTPSample.getText());
                }
                catch (NumberFormatException nfe) {
                    int length = this.proxyPauseHTTPSample.getText().length();
                    if (length <= 0) break block5;
                    JOptionPane.showMessageDialog(this, JMeterUtils.getResString((String)"proxy_settings_pause_error_digits"), JMeterUtils.getResString((String)"proxy_settings_pause_error_invalid_data"), 2);
                    this.proxyPauseHTTPSample.setText(this.proxyPauseHTTPSample.getText().substring(0, length - 1));
                }
            }
            this.recorderGui.setProxyPauseHTTPSample(this.proxyPauseHTTPSample.getText());
            this.recorderGui.enableRestart();
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.recorderGui.stopRecorder();
    }
}

