/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.proxy;

import java.awt.event.ActionEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.Timer;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.conn.ssl.AbstractVerifier;
import org.apache.jmeter.assertions.Assertion;
import org.apache.jmeter.assertions.ResponseAssertion;
import org.apache.jmeter.assertions.gui.AssertionGui;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.config.ConfigElement;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.control.GenericController;
import org.apache.jmeter.control.TransactionController;
import org.apache.jmeter.control.gui.LogicControllerGui;
import org.apache.jmeter.control.gui.TransactionControllerGui;
import org.apache.jmeter.engine.util.ValueReplacer;
import org.apache.jmeter.exceptions.IllegalUserActionException;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.Stoppable;
import org.apache.jmeter.gui.tree.JMeterTreeModel;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.processor.PostProcessor;
import org.apache.jmeter.processor.PreProcessor;
import org.apache.jmeter.protocol.http.control.AuthManager;
import org.apache.jmeter.protocol.http.control.Authorization;
import org.apache.jmeter.protocol.http.control.Header;
import org.apache.jmeter.protocol.http.control.HeaderManager;
import org.apache.jmeter.protocol.http.control.RecordingController;
import org.apache.jmeter.protocol.http.gui.AuthPanel;
import org.apache.jmeter.protocol.http.proxy.Daemon;
import org.apache.jmeter.protocol.http.sampler.HTTPSampleResult;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerBase;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleListener;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testbeans.TestBeanHelper;
import org.apache.jmeter.testelement.NonTestElement;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestPlan;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.IntegerProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.testelement.property.TestElementProperty;
import org.apache.jmeter.threads.AbstractThreadGroup;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.Visualizer;
import org.apache.jorphan.exec.KeyToolUtils;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.oro.text.MalformedCachePatternException;
import org.apache.oro.text.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyControl
extends GenericController
implements NonTestElement {
    private static final Logger log = LoggerFactory.getLogger(ProxyControl.class);
    private static final long serialVersionUID = 240L;
    private static final String ASSERTION_GUI = AssertionGui.class.getName();
    private static final String TRANSACTION_CONTROLLER_GUI = TransactionControllerGui.class.getName();
    private static final String LOGIC_CONTROLLER_GUI = LogicControllerGui.class.getName();
    private static final String AUTH_PANEL = AuthPanel.class.getName();
    private static final String AUTH_MANAGER = AuthManager.class.getName();
    public static final int DEFAULT_PORT = 8888;
    public static final String DEFAULT_PORT_S = Integer.toString(8888);
    private static final String PORT = "ProxyControlGui.port";
    private static final String DOMAINS = "ProxyControlGui.domains";
    private static final String EXCLUDE_LIST = "ProxyControlGui.exclude_list";
    private static final String INCLUDE_LIST = "ProxyControlGui.include_list";
    private static final String CAPTURE_HTTP_HEADERS = "ProxyControlGui.capture_http_headers";
    private static final String ADD_ASSERTIONS = "ProxyControlGui.add_assertion";
    private static final String GROUPING_MODE = "ProxyControlGui.grouping_mode";
    private static final String SAMPLER_TYPE_NAME = "ProxyControlGui.sampler_type_name";
    private static final String SAMPLER_REDIRECT_AUTOMATICALLY = "ProxyControlGui.sampler_redirect_automatically";
    private static final String SAMPLER_FOLLOW_REDIRECTS = "ProxyControlGui.sampler_follow_redirects";
    private static final String USE_KEEPALIVE = "ProxyControlGui.use_keepalive";
    private static final String SAMPLER_DOWNLOAD_IMAGES = "ProxyControlGui.sampler_download_images";
    private static final String HTTP_SAMPLER_NAMING_MODE = "ProxyControlGui.proxy_http_sampler_naming_mode";
    private static final String PREFIX_HTTP_SAMPLER_NAME = "ProxyControlGui.proxy_prefix_http_sampler_name";
    private static final String PROXY_PAUSE_HTTP_SAMPLER = "ProxyControlGui.proxy_pause_http_sampler";
    private static final String DEFAULT_ENCODING_PROPERTY = "ProxyControlGui.default_encoding";
    private static final String REGEX_MATCH = "ProxyControlGui.regex_match";
    private static final String CONTENT_TYPE_EXCLUDE = "ProxyControlGui.content_type_exclude";
    private static final String CONTENT_TYPE_INCLUDE = "ProxyControlGui.content_type_include";
    private static final String NOTIFY_CHILD_SAMPLER_LISTENERS_FILTERED = "ProxyControlGui.notify_child_sl_filtered";
    private static final String BEARER_AUTH = "Bearer";
    private static final String BASIC_AUTH = "Basic";
    private static final String DIGEST_AUTH = "Digest";
    private static final int GROUPING_ADD_SEPARATORS = 1;
    private static final int GROUPING_IN_SIMPLE_CONTROLLERS = 2;
    private static final int GROUPING_STORE_FIRST_ONLY = 3;
    private static final int GROUPING_IN_TRANSACTION_CONTROLLERS = 4;
    private static final String SAMPLER_TYPE_HTTP_SAMPLER_JAVA = "0";
    private static final String SAMPLER_TYPE_HTTP_SAMPLER_HC3_1 = "1";
    private static final String SAMPLER_TYPE_HTTP_SAMPLER_HC4 = "2";
    private long sampleGap;
    private static final String KEYSTORE_TYPE = JMeterUtils.getPropDefault((String)"proxy.cert.type", (String)"JKS");
    private static final String CERT_DIRECTORY = JMeterUtils.getPropDefault((String)"proxy.cert.directory", (String)JMeterUtils.getJMeterBinDir());
    private static final String CERT_FILE_DEFAULT = "proxyserver.jks";
    private static final String CERT_FILE = JMeterUtils.getPropDefault((String)"proxy.cert.file", (String)"proxyserver.jks");
    private static final File CERT_PATH = new File(CERT_DIRECTORY, CERT_FILE);
    private static final String CERT_PATH_ABS = CERT_PATH.getAbsolutePath();
    private static final String DEFAULT_PASSWORD = "password";
    private static final String USER_PASSWORD_KEY = "proxy_cert_password";
    private static final Preferences PREFERENCES = Preferences.userNodeForPackage(ProxyControl.class);
    private static final boolean USE_DYNAMIC_KEYS = JMeterUtils.getPropDefault((String)"proxy.cert.dynamic_keys", (boolean)true);
    static final String JMETER_SERVER_ALIAS = ":jmeter:";
    public static final int CERT_VALIDITY = JMeterUtils.getPropDefault((String)"proxy.cert.validity", (int)7);
    static final String CERT_ALIAS = JMeterUtils.getProperty((String)"proxy.cert.alias");
    static final KeystoreMode KEYSTORE_MODE;
    private static final boolean USE_REDIRECT_DISABLING;
    private static String LAST_REDIRECT;
    private transient Daemon server;
    private long lastTime = 0L;
    private transient KeyStore keyStore;
    private volatile boolean addAssertions = false;
    private volatile int groupingMode = 0;
    private volatile boolean samplerRedirectAutomatically = false;
    private volatile boolean samplerFollowRedirects = false;
    private volatile boolean useKeepAlive = false;
    private volatile boolean samplerDownloadImages = false;
    private volatile boolean notifyChildSamplerListenersOfFilteredSamples = true;
    private volatile boolean regexMatch = false;
    private Set<Class<?>> addableInterfaces = new HashSet<Class>(Arrays.asList(Visualizer.class, ConfigElement.class, Assertion.class, org.apache.jmeter.timers.Timer.class, PreProcessor.class, PostProcessor.class, SampleListener.class));
    private JMeterTreeNode target;
    private String storePassword;
    private String keyPassword;
    private JMeterTreeModel nonGuiTreeModel;
    private ArrayDeque<SamplerInfo> sampleQueue = new ArrayDeque();
    private String oldPrefix = null;

    public ProxyControl() {
        this.setPort(8888);
        this.setExcludeList(new HashSet<String>());
        this.setIncludeList(new HashSet<String>());
        this.setCaptureHttpHeaders(true);
        new Timer(200, this::putSamplesIntoModel).start();
    }

    public void setNonGuiTreeModel(JMeterTreeModel treeModel) {
        this.nonGuiTreeModel = treeModel;
    }

    public void setPort(int port) {
        this.setProperty((JMeterProperty)new IntegerProperty(PORT, port));
    }

    public void setPort(String port) {
        this.setProperty(PORT, port);
    }

    public void setSslDomains(String domains) {
        this.setProperty(DOMAINS, domains, "");
    }

    public String getSslDomains() {
        return this.getPropertyAsString(DOMAINS, "");
    }

    public void setCaptureHttpHeaders(boolean capture) {
        this.setProperty((JMeterProperty)new BooleanProperty(CAPTURE_HTTP_HEADERS, capture));
    }

    public void setGroupingMode(int grouping) {
        this.groupingMode = grouping;
        this.setProperty((JMeterProperty)new IntegerProperty(GROUPING_MODE, grouping));
    }

    public void setAssertions(boolean b) {
        this.addAssertions = b;
        this.setProperty((JMeterProperty)new BooleanProperty(ADD_ASSERTIONS, b));
    }

    public void setSamplerTypeName(String samplerTypeName) {
        this.setProperty((JMeterProperty)new StringProperty(SAMPLER_TYPE_NAME, samplerTypeName));
    }

    public void setSamplerRedirectAutomatically(boolean b) {
        this.samplerRedirectAutomatically = b;
        this.setProperty((JMeterProperty)new BooleanProperty(SAMPLER_REDIRECT_AUTOMATICALLY, b));
    }

    public void setSamplerFollowRedirects(boolean b) {
        this.samplerFollowRedirects = b;
        this.setProperty((JMeterProperty)new BooleanProperty(SAMPLER_FOLLOW_REDIRECTS, b));
    }

    public void setUseKeepAlive(boolean b) {
        this.useKeepAlive = b;
        this.setProperty((JMeterProperty)new BooleanProperty(USE_KEEPALIVE, b));
    }

    public void setSamplerDownloadImages(boolean b) {
        this.samplerDownloadImages = b;
        this.setProperty((JMeterProperty)new BooleanProperty(SAMPLER_DOWNLOAD_IMAGES, b));
    }

    public void setHTTPSampleNamingMode(int httpNamingMode) {
        this.setProperty((JMeterProperty)new IntegerProperty(HTTP_SAMPLER_NAMING_MODE, httpNamingMode));
    }

    public String getDefaultEncoding() {
        return this.getPropertyAsString(DEFAULT_ENCODING_PROPERTY, StandardCharsets.UTF_8.name());
    }

    public void setDefaultEncoding(String defaultEncoding) {
        this.setProperty(DEFAULT_ENCODING_PROPERTY, defaultEncoding);
    }

    public void setPrefixHTTPSampleName(String prefixHTTPSampleName) {
        this.setProperty(PREFIX_HTTP_SAMPLER_NAME, prefixHTTPSampleName);
    }

    public void setProxyPauseHTTPSample(String proxyPauseHTTPSample) {
        this.setProperty(PROXY_PAUSE_HTTP_SAMPLER, proxyPauseHTTPSample);
    }

    public void setNotifyChildSamplerListenerOfFilteredSamplers(boolean b) {
        this.notifyChildSamplerListenersOfFilteredSamples = b;
        this.setProperty((JMeterProperty)new BooleanProperty(NOTIFY_CHILD_SAMPLER_LISTENERS_FILTERED, b));
    }

    public void setIncludeList(Collection<String> list) {
        this.setProperty((JMeterProperty)new CollectionProperty(INCLUDE_LIST, new HashSet<String>(list)));
    }

    public void setExcludeList(Collection<String> list) {
        this.setProperty((JMeterProperty)new CollectionProperty(EXCLUDE_LIST, new HashSet<String>(list)));
    }

    public void setRegexMatch(boolean b) {
        this.regexMatch = b;
        this.setProperty((JMeterProperty)new BooleanProperty(REGEX_MATCH, b));
    }

    public void setContentTypeExclude(String contentTypeExclude) {
        this.setProperty((JMeterProperty)new StringProperty(CONTENT_TYPE_EXCLUDE, contentTypeExclude));
    }

    public void setContentTypeInclude(String contentTypeInclude) {
        this.setProperty((JMeterProperty)new StringProperty(CONTENT_TYPE_INCLUDE, contentTypeInclude));
    }

    public boolean getAssertions() {
        return this.getPropertyAsBoolean(ADD_ASSERTIONS);
    }

    public int getGroupingMode() {
        return this.getPropertyAsInt(GROUPING_MODE);
    }

    public int getPort() {
        return this.getPropertyAsInt(PORT);
    }

    public String getPortString() {
        return this.getPropertyAsString(PORT);
    }

    public int getDefaultPort() {
        return 8888;
    }

    public boolean getCaptureHttpHeaders() {
        return this.getPropertyAsBoolean(CAPTURE_HTTP_HEADERS);
    }

    public String getSamplerTypeName() {
        String type = this.getPropertyAsString(SAMPLER_TYPE_NAME);
        if (SAMPLER_TYPE_HTTP_SAMPLER_JAVA.equals(type)) {
            type = "Java";
        } else if (SAMPLER_TYPE_HTTP_SAMPLER_HC3_1.equals(type)) {
            type = "HttpClient4";
        } else if (SAMPLER_TYPE_HTTP_SAMPLER_HC4.equals(type)) {
            type = "HttpClient4";
        }
        return type;
    }

    public boolean getSamplerRedirectAutomatically() {
        return this.getPropertyAsBoolean(SAMPLER_REDIRECT_AUTOMATICALLY, false);
    }

    public boolean getSamplerFollowRedirects() {
        return this.getPropertyAsBoolean(SAMPLER_FOLLOW_REDIRECTS, true);
    }

    public boolean getUseKeepalive() {
        return this.getPropertyAsBoolean(USE_KEEPALIVE, true);
    }

    public boolean getSamplerDownloadImages() {
        return this.getPropertyAsBoolean(SAMPLER_DOWNLOAD_IMAGES, false);
    }

    public int getHTTPSampleNamingMode() {
        return this.getPropertyAsInt(HTTP_SAMPLER_NAMING_MODE);
    }

    public String getPrefixHTTPSampleName() {
        return this.getPropertyAsString(PREFIX_HTTP_SAMPLER_NAME);
    }

    public String getProxyPauseHTTPSample() {
        return this.getPropertyAsString(PROXY_PAUSE_HTTP_SAMPLER);
    }

    public boolean getNotifyChildSamplerListenerOfFilteredSamplers() {
        return this.getPropertyAsBoolean(NOTIFY_CHILD_SAMPLER_LISTENERS_FILTERED, true);
    }

    public boolean getRegexMatch() {
        return this.getPropertyAsBoolean(REGEX_MATCH, false);
    }

    public String getContentTypeExclude() {
        return this.getPropertyAsString(CONTENT_TYPE_EXCLUDE);
    }

    public String getContentTypeInclude() {
        return this.getPropertyAsString(CONTENT_TYPE_INCLUDE);
    }

    public JMeterTreeModel getNonGuiTreeModel() {
        return this.nonGuiTreeModel;
    }

    public void addConfigElement(ConfigElement config) {
    }

    public void startProxy() throws IOException {
        try {
            this.initKeyStore();
        }
        catch (GeneralSecurityException e) {
            log.error("Could not initialise key store", (Throwable)e);
            throw new IOException("Could not create keystore", e);
        }
        catch (IOException e) {
            log.error("Could not initialise key store", (Throwable)e);
            throw e;
        }
        this.notifyTestListenersOfStart();
        try {
            this.server = new Daemon(this.getPort(), this);
            this.sampleGap = this.getProxyPauseHTTPSample().isEmpty() ? (long)JMeterUtils.getPropDefault((String)"proxy.pause", (int)5000) : Long.parseLong(this.getProxyPauseHTTPSample().trim());
            this.server.start();
            if (GuiPackage.getInstance() != null) {
                GuiPackage.getInstance().register((Stoppable)this.server);
            }
        }
        catch (IOException e) {
            log.error("Could not create HTTP(S) Test Script Recorder Proxy daemon", (Throwable)e);
            throw e;
        }
    }

    public void addExcludedPattern(String pattern) {
        this.getExcludePatterns().addItem((Object)pattern);
    }

    public CollectionProperty getExcludePatterns() {
        return (CollectionProperty)this.getProperty(EXCLUDE_LIST);
    }

    public void addIncludedPattern(String pattern) {
        this.getIncludePatterns().addItem((Object)pattern);
    }

    public CollectionProperty getIncludePatterns() {
        return (CollectionProperty)this.getProperty(INCLUDE_LIST);
    }

    public void clearExcludedPatterns() {
        this.getExcludePatterns().clear();
    }

    public void clearIncludedPatterns() {
        this.getIncludePatterns().clear();
    }

    public JMeterTreeNode getTarget() {
        return this.target;
    }

    public void setTarget(JMeterTreeNode target) {
        this.target = target;
    }

    public synchronized void deliverSampler(HTTPSamplerBase sampler, TestElement[] testElements, SampleResult result) {
        boolean notifySampleListeners = true;
        if (sampler != null) {
            if (USE_REDIRECT_DISABLING && (this.samplerRedirectAutomatically || this.samplerFollowRedirects) && result instanceof HTTPSampleResult) {
                HTTPSampleResult httpSampleResult = (HTTPSampleResult)result;
                String urlAsString = httpSampleResult.getUrlAsString();
                if (urlAsString.equals(LAST_REDIRECT)) {
                    sampler.setEnabled(false);
                    sampler.setComment("Detected a redirect from the previous sample");
                } else {
                    LAST_REDIRECT = null;
                }
                if (httpSampleResult.isRedirect()) {
                    if (LAST_REDIRECT == null) {
                        sampler.setComment("Detected the start of a redirect chain");
                    }
                    LAST_REDIRECT = httpSampleResult.getRedirectLocation();
                } else {
                    LAST_REDIRECT = null;
                }
            }
            if (this.filterContentType(result) && this.filterUrl(sampler)) {
                JMeterTreeNode myTarget = this.findTargetControllerNode();
                Collection<ConfigTestElement> defaultConfigurations = this.findApplicableElements(myTarget, ConfigTestElement.class, false);
                Collection<Arguments> userDefinedVariables = this.findApplicableElements(myTarget, Arguments.class, true);
                this.removeValuesFromSampler(sampler, defaultConfigurations);
                this.replaceValues((TestElement)sampler, testElements, userDefinedVariables);
                sampler.setAutoRedirects(this.samplerRedirectAutomatically);
                sampler.setFollowRedirects(this.samplerFollowRedirects);
                sampler.setUseKeepAlive(this.useKeepAlive);
                sampler.setImageParser(this.samplerDownloadImages);
                Authorization authorization = this.createAuthorization(testElements, sampler);
                if (authorization != null) {
                    this.setAuthorization(authorization, myTarget);
                }
                this.sampleQueue.add(new SamplerInfo(sampler, testElements, myTarget, this.getPrefixHTTPSampleName(), this.groupingMode));
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("Sample excluded based on url or content-type: {} - {}", (Object)result.getUrlAsString(), (Object)result.getContentType());
                }
                notifySampleListeners = this.notifyChildSamplerListenersOfFilteredSamples;
                result.setSampleLabel("[" + result.getSampleLabel() + "]");
            }
        }
        if (notifySampleListeners) {
            this.notifySampleListeners(new SampleEvent(result, "WorkBench"));
        } else {
            log.debug("Sample not delivered to Child Sampler Listener based on url or content-type: {} - {}", (Object)result.getUrlAsString(), (Object)result.getContentType());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Authorization createAuthorization(TestElement[] testElements, HTTPSamplerBase sampler) {
        Authorization authorization = null;
        TestElement[] testElementArray = testElements;
        int n = testElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            TestElement te = testElementArray[n2];
            if (te instanceof HeaderManager) {
                ArrayList headers = (ArrayList)((HeaderManager)te).getHeaders().getObjectValue();
                Iterator iterator = headers.iterator();
                while (iterator.hasNext()) {
                    TestElementProperty tep = (TestElementProperty)iterator.next();
                    if (!tep.getName().equals("Authorization")) continue;
                    Header authHeader = (Header)tep.getObjectValue();
                    String headerValue = authHeader.getValue().trim();
                    String[] authHeaderContent = headerValue.split(" ");
                    if (authHeaderContent.length >= 2) {
                        AuthManager.Mechanism mechanism;
                        String authType;
                        switch (authType = authHeaderContent[0]) {
                            case "Bearer": {
                                return null;
                            }
                            case "Digest": {
                                mechanism = AuthManager.Mechanism.DIGEST;
                                break;
                            }
                            case "Basic": {
                                mechanism = AuthManager.Mechanism.BASIC;
                                break;
                            }
                            default: {
                                mechanism = AuthManager.Mechanism.KERBEROS;
                            }
                        }
                        String authCredentialsBase64 = authHeaderContent[1];
                        authorization = new Authorization();
                        try {
                            authorization.setURL(sampler.getUrl().toExternalForm());
                        }
                        catch (MalformedURLException e) {
                            log.error("Error filling url on authorization, message: {}", (Object)e.getMessage(), (Object)e);
                            authorization.setURL("${AUTH_BASE_URL}");
                        }
                        authorization.setMechanism(mechanism);
                        if (BASIC_AUTH.equals(authType)) {
                            String authCred = new String(Base64.decodeBase64((String)authCredentialsBase64));
                            String[] loginPassword = authCred.split(":");
                            if (loginPassword.length != 2) {
                                log.error("Error parsing BASIC Auth authorization header:'{}', decoded value:'{}'", (Object)authCredentialsBase64, (Object)authCred);
                                return null;
                            }
                            authorization.setUser(loginPassword[0]);
                            authorization.setPass(loginPassword[1]);
                        } else {
                            authorization.setUser("${AUTH_LOGIN}");
                            authorization.setPass("${AUTH_PASSWORD}");
                        }
                    }
                    iterator.remove();
                    break;
                }
            }
            ++n2;
        }
        return authorization;
    }

    public void stopProxy() {
        if (this.server != null) {
            this.server.stopServer();
            if (GuiPackage.getInstance() != null) {
                GuiPackage.getInstance().unregister((Stoppable)this.server);
            }
            try {
                this.server.join(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.notifyTestListenersOfEnd();
            this.server = null;
        }
    }

    public String[] getCertificateDetails() {
        if (ProxyControl.isDynamicMode()) {
            try {
                X509Certificate caCert = (X509Certificate)this.keyStore.getCertificate(KeyToolUtils.getRootCAalias());
                if (caCert == null) {
                    return new String[]{"Could not find certificate"};
                }
                return new String[]{caCert.getSubjectX500Principal().toString(), "Fingerprint(SHA1): " + JOrphanUtils.baToHexString((byte[])DigestUtils.sha1((byte[])caCert.getEncoded()), (char)' '), "Created: " + caCert.getNotBefore().toString()};
            }
            catch (GeneralSecurityException e) {
                log.error("Problem reading root CA from keystore", (Throwable)e);
                return new String[]{"Problem with root certificate", e.getMessage()};
            }
        }
        return new String[0];
    }

    boolean filterUrl(HTTPSamplerBase sampler) {
        String domain = sampler.getDomain();
        if (domain == null || domain.length() == 0) {
            return false;
        }
        String url = this.generateMatchUrl(sampler);
        CollectionProperty includePatterns = this.getIncludePatterns();
        if (includePatterns.size() > 0 && !this.matchesPatterns(url, includePatterns)) {
            return false;
        }
        CollectionProperty excludePatterns = this.getExcludePatterns();
        return excludePatterns.size() <= 0 || !this.matchesPatterns(url, excludePatterns);
    }

    boolean filterContentType(SampleResult result) {
        boolean matched;
        String includeExp = this.getContentTypeInclude();
        String excludeExp = this.getContentTypeExclude();
        if (!(includeExp != null && includeExp.length() != 0 || excludeExp != null && excludeExp.length() != 0)) {
            return true;
        }
        String sampleContentType = result.getContentType();
        if (sampleContentType == null || sampleContentType.length() == 0) {
            if (log.isDebugEnabled()) {
                log.debug("No Content-type found for : {}", (Object)result.getUrlAsString());
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug("Content-type to filter : {}", (Object)sampleContentType);
        }
        if (!(matched = this.testPattern(includeExp, sampleContentType, true))) {
            return false;
        }
        matched = this.testPattern(excludeExp, sampleContentType, false);
        return matched;
    }

    private boolean testPattern(String expression, String sampleContentType, boolean expectedToMatch) {
        if (expression != null && expression.length() > 0) {
            if (log.isDebugEnabled()) {
                log.debug("Testing Expression : {} on sampleContentType: {}, expected to match: {}", new Object[]{expression, sampleContentType, expectedToMatch});
            }
            Pattern pattern = null;
            try {
                pattern = JMeterUtils.getPatternCache().getPattern(expression, 32784);
                if (JMeterUtils.getMatcher().contains(sampleContentType, pattern) != expectedToMatch) {
                    return false;
                }
            }
            catch (MalformedCachePatternException e) {
                log.warn("Skipped invalid content pattern: {}", (Object)expression, (Object)e);
            }
        }
        return true;
    }

    private void setAuthorization(Authorization authorization, JMeterTreeNode target) {
        JMeterTreeModel jmeterTreeModel = this.getJmeterTreeModel();
        List authManagerNodes = jmeterTreeModel.getNodesOfType(AuthManager.class);
        if (authManagerNodes.isEmpty()) {
            try {
                log.debug("Creating HTTP Authentication manager for authorization: {}", (Object)authorization);
                AuthManager authManager = this.newAuthorizationManager(authorization);
                jmeterTreeModel.addComponent((TestElement)authManager, target);
            }
            catch (IllegalUserActionException e) {
                log.error("Failed to add Authorization Manager to target node: {}", (Object)target.getName(), (Object)e);
            }
        } else {
            AuthManager authManager = (AuthManager)((JMeterTreeNode)authManagerNodes.get(0)).getTestElement();
            authManager.addAuth(authorization);
        }
    }

    private JMeterTreeModel getJmeterTreeModel() {
        if (this.nonGuiTreeModel == null) {
            return GuiPackage.getInstance().getTreeModel();
        }
        return this.nonGuiTreeModel;
    }

    private void addAssertion(JMeterTreeModel model, JMeterTreeNode node) throws IllegalUserActionException {
        ResponseAssertion ra = new ResponseAssertion();
        ra.setProperty("TestElement.gui_class", ASSERTION_GUI);
        ra.setName(JMeterUtils.getResString((String)"assertion_title"));
        ra.setTestFieldResponseData();
        model.addComponent((TestElement)ra, node);
    }

    private AuthManager newAuthorizationManager(Authorization authorization) {
        AuthManager authManager = new AuthManager();
        authManager.setProperty("TestElement.gui_class", AUTH_PANEL);
        authManager.setProperty("TestElement.test_class", AUTH_MANAGER);
        authManager.setName("HTTP Authorization Manager");
        authManager.addAuth(authorization);
        return authManager;
    }

    private void addDivider(JMeterTreeModel model, JMeterTreeNode node) {
        GenericController sc = new GenericController();
        sc.setProperty("TestElement.gui_class", LOGIC_CONTROLLER_GUI);
        sc.setName("-------------------");
        this.safelyAddComponent(model, node, sc);
    }

    private void safelyAddComponent(JMeterTreeModel model, JMeterTreeNode node, GenericController controller) {
        JMeterUtils.runSafe((boolean)true, () -> {
            try {
                model.addComponent((TestElement)controller, node);
            }
            catch (IllegalUserActionException e) {
                log.error("Program error", (Throwable)e);
                throw new Error(e);
            }
        });
    }

    private void addSimpleController(JMeterTreeModel model, JMeterTreeNode node, String name) {
        GenericController sc = new GenericController();
        sc.setProperty("TestElement.gui_class", LOGIC_CONTROLLER_GUI);
        sc.setName(name);
        this.safelyAddComponent(model, node, sc);
    }

    private void addTransactionController(JMeterTreeModel model, JMeterTreeNode node, String name) {
        TransactionController sc = new TransactionController();
        sc.setIncludeTimers(false);
        sc.setProperty("TestElement.gui_class", TRANSACTION_CONTROLLER_GUI);
        sc.setName(name);
        this.safelyAddComponent(model, node, (GenericController)sc);
    }

    private void addTimers(JMeterTreeModel model, JMeterTreeNode node, long deltaT) {
        TestPlan variables = new TestPlan();
        variables.addParameter("T", Long.toString(deltaT));
        ValueReplacer replacer = new ValueReplacer(variables);
        JMeterTreeNode mySelf = model.getNodeOf((TestElement)this);
        if (mySelf != null) {
            Enumeration children = mySelf.children();
            while (children.hasMoreElements()) {
                TestElement template;
                JMeterTreeNode templateNode = (JMeterTreeNode)children.nextElement();
                if (!templateNode.isEnabled() || !((template = templateNode.getTestElement()) instanceof org.apache.jmeter.timers.Timer)) continue;
                TestElement timer = (TestElement)template.clone();
                try {
                    timer.setComment("Recorded:" + Long.toString(deltaT) + "ms");
                    replacer.undoReverseReplace(timer);
                    model.addComponent(timer, node);
                }
                catch (IllegalUserActionException | InvalidVariableException e) {
                    log.error("Program error adding timers", e);
                    throw new Error(e);
                }
            }
        }
    }

    private JMeterTreeNode findFirstNodeOfType(Class<?> type) {
        JMeterTreeModel treeModel = this.getJmeterTreeModel();
        List nodes = treeModel.getNodesOfType(type);
        for (JMeterTreeNode node : nodes) {
            if (!node.isEnabled()) continue;
            return node;
        }
        return null;
    }

    public JMeterTreeNode findTargetControllerNode() {
        JMeterTreeNode myTarget = this.getTarget();
        if (myTarget != null) {
            return myTarget;
        }
        myTarget = this.findFirstNodeOfType(RecordingController.class);
        if (myTarget != null) {
            return myTarget;
        }
        myTarget = this.findFirstNodeOfType(AbstractThreadGroup.class);
        if (myTarget != null) {
            return myTarget;
        }
        log.error("Program error: test script recording target not found.");
        return null;
    }

    private Collection<?> findApplicableElements(JMeterTreeNode myTarget, Class<? extends TestElement> myClass, boolean ascending) {
        JMeterTreeModel treeModel = this.getJmeterTreeModel();
        LinkedList<Object> elements = new LinkedList<Object>();
        JMeterTreeNode node = treeModel.getNodeOf((TestElement)this);
        if (node != null) {
            Enumeration kids = node.children();
            while (kids.hasMoreElements()) {
                TestElement element;
                JMeterTreeNode subNode = (JMeterTreeNode)kids.nextElement();
                if (!subNode.isEnabled() || !myClass.isInstance(element = (TestElement)subNode.getUserObject())) continue;
                if (ascending) {
                    elements.addFirst(element);
                    continue;
                }
                elements.add(element);
            }
        }
        for (JMeterTreeNode controller = myTarget; controller != null; controller = (JMeterTreeNode)controller.getParent()) {
            Enumeration kids = controller.children();
            while (kids.hasMoreElements()) {
                TestPlan tp;
                Arguments args;
                JMeterTreeNode subNode = (JMeterTreeNode)kids.nextElement();
                if (!subNode.isEnabled()) continue;
                TestElement element = (TestElement)subNode.getUserObject();
                if (myClass.isInstance(element)) {
                    log.debug("Applicable: {}", (Object)element.getName());
                    if (ascending) {
                        elements.addFirst(element);
                    } else {
                        elements.add(element);
                    }
                }
                if (!(element instanceof TestPlan) || !myClass.isInstance(args = (tp = (TestPlan)element).getArguments())) continue;
                if (ascending) {
                    elements.addFirst(args);
                    continue;
                }
                elements.add(args);
            }
        }
        return elements;
    }

    private void putSamplesIntoModel(ActionEvent e) {
        if (this.sampleQueue.isEmpty()) {
            return;
        }
        JMeterTreeModel treeModel = this.getJmeterTreeModel();
        while (!this.sampleQueue.isEmpty()) {
            SamplerInfo info = this.sampleQueue.poll();
            try {
                log.info("Add sample {} into controller {}", (Object)info.sampler.getName(), (Object)info.prefix);
                try {
                    long now = info.recordedAt;
                    long deltaT = now - this.lastTime;
                    boolean firstInBatch = this.prepareTree(treeModel, deltaT, info);
                    if (this.lastTime == 0L) {
                        deltaT = 0L;
                    }
                    this.lastTime = now;
                    if (info.groupingMode == 3) {
                        if (!firstInBatch) {
                            return;
                        }
                        info.sampler.setFollowRedirects(true);
                        info.sampler.setImageParser(true);
                    }
                    JMeterTreeNode targetNode = this.getTargetNode(info.target, info.groupingMode);
                    JMeterTreeNode newNode = treeModel.addComponent((TestElement)info.sampler, targetNode);
                    if (firstInBatch) {
                        if (this.addAssertions) {
                            this.addAssertion(treeModel, newNode);
                        }
                        this.addTimers(treeModel, newNode, deltaT);
                    }
                    this.addTestElements(treeModel, info.testElements, newNode);
                }
                catch (IllegalUserActionException ex) {
                    log.error("Error placing sampler", (Throwable)ex);
                    JMeterUtils.reportErrorToUser((String)ex.getMessage());
                }
            }
            catch (Exception ex) {
                log.error("Error placing sampler", (Throwable)ex);
                JMeterUtils.reportErrorToUser((String)ex.getMessage());
            }
        }
    }

    private void addTestElements(JMeterTreeModel treeModel, TestElement[] testElements, JMeterTreeNode newNode) throws IllegalUserActionException {
        if (testElements == null) {
            return;
        }
        for (TestElement testElement : testElements) {
            if (!this.isAddableTestElement(testElement)) continue;
            treeModel.addComponent(testElement, newNode);
        }
    }

    private boolean prepareTree(JMeterTreeModel treeModel, long deltaT, SamplerInfo info) {
        HTTPSamplerBase sampler = info.sampler;
        JMeterTreeNode myTarget = info.target;
        int cachedGroupingMode = info.groupingMode;
        boolean prefixChanged = false;
        if (this.oldPrefix == null || !this.oldPrefix.equals(info.prefix)) {
            this.oldPrefix = info.prefix;
            prefixChanged = true;
        }
        if (deltaT > this.sampleGap || prefixChanged) {
            String controllerName = StringUtils.defaultString((String)this.getPrefixHTTPSampleName(), (String)sampler.getName());
            if (!myTarget.isLeaf() && cachedGroupingMode == 1) {
                this.addDivider(treeModel, myTarget);
            }
            if (cachedGroupingMode == 2) {
                this.addSimpleController(treeModel, myTarget, controllerName);
            }
            if (cachedGroupingMode == 4) {
                this.addTransactionController(treeModel, myTarget, controllerName);
            }
            return true;
        }
        return false;
    }

    private JMeterTreeNode getTargetNode(JMeterTreeNode origTarget, int cachedGroupingMode) {
        if (cachedGroupingMode == 2 || cachedGroupingMode == 4) {
            for (int i = origTarget.getChildCount() - 1; i >= 0; --i) {
                JMeterTreeNode currentNode = (JMeterTreeNode)origTarget.getChildAt(i);
                if (!(currentNode.getTestElement() instanceof GenericController)) continue;
                return currentNode;
            }
        }
        return origTarget;
    }

    private boolean isAddableTestElement(TestElement testElement) {
        if (this.hasCorrectInterface(testElement, this.addableInterfaces)) {
            if (testElement.getProperty("TestElement.gui_class") != null) {
                return true;
            }
            log.error("Cannot add element that lacks the {} property as testElement: {}", (Object)"TestElement.gui_class", (Object)testElement);
            return false;
        }
        return false;
    }

    private boolean hasCorrectInterface(Object obj, Set<Class<?>> klasses) {
        for (Class<?> klass : klasses) {
            if (klass == null || !klass.isInstance(obj)) continue;
            return true;
        }
        return false;
    }

    private void removeValuesFromSampler(HTTPSamplerBase sampler, Collection<ConfigTestElement> configurations) {
        PropertyIterator props = sampler.propertyIterator();
        block0: while (props.hasNext()) {
            JMeterProperty prop = props.next();
            String name = prop.getName();
            String value = prop.getStringValue();
            if (name.equals("TestElement.enabled") || name.equals("TestElement.gui_class") || name.equals("TestElement.name") || name.equals("TestElement.test_class")) continue;
            for (ConfigTestElement config : configurations) {
                String configValue = config.getPropertyAsString(name);
                if (configValue == null || configValue.length() <= 0) continue;
                if (!configValue.equals(value)) continue block0;
                sampler.setProperty(name, "");
                continue block0;
            }
        }
    }

    private String generateMatchUrl(HTTPSamplerBase sampler) {
        StringBuilder buf = new StringBuilder(sampler.getDomain());
        buf.append(':');
        buf.append(sampler.getPort());
        buf.append(sampler.getPath());
        if (sampler.getQueryString().length() > 0) {
            buf.append('?');
            buf.append(sampler.getQueryString());
        }
        return buf.toString();
    }

    private boolean matchesPatterns(String url, CollectionProperty patterns) {
        for (JMeterProperty jMeterProperty : patterns) {
            String item = jMeterProperty.getStringValue();
            try {
                Pattern pattern = JMeterUtils.getPatternCache().getPattern(item, 32784);
                if (!JMeterUtils.getMatcher().matches(url, pattern)) continue;
                return true;
            }
            catch (MalformedCachePatternException e) {
                log.warn("Skipped invalid pattern: {}", (Object)item, (Object)e);
            }
        }
        return false;
    }

    private void replaceValues(TestElement sampler, TestElement[] configs, Collection<Arguments> variables) {
        ValueReplacer replacer = new ValueReplacer();
        for (Arguments variable : variables) {
            Map map = variable.getArgumentsAsMap();
            map.values().removeIf(""::equals);
            replacer.addVariables(map);
        }
        try {
            boolean cachedRegexpMatch = this.regexMatch;
            replacer.reverseReplace(sampler, cachedRegexpMatch);
            for (TestElement config : configs) {
                if (config == null) continue;
                replacer.reverseReplace(config, cachedRegexpMatch);
            }
        }
        catch (InvalidVariableException e) {
            log.warn("Invalid variables included for replacement into recorded sample", (Throwable)e);
        }
    }

    private void notifySampleListeners(SampleEvent event) {
        JMeterTreeModel treeModel = this.getJmeterTreeModel();
        JMeterTreeNode myNode = treeModel.getNodeOf((TestElement)this);
        if (myNode != null) {
            Enumeration kids = myNode.children();
            while (kids.hasMoreElements()) {
                TestElement testElement;
                JMeterTreeNode subNode = (JMeterTreeNode)kids.nextElement();
                if (!subNode.isEnabled() || !((testElement = subNode.getTestElement()) instanceof SampleListener)) continue;
                ((SampleListener)testElement).sampleOccurred(event);
            }
        }
    }

    private void notifyTestListenersOfStart() {
        JMeterTreeModel treeModel = this.getJmeterTreeModel();
        JMeterTreeNode myNode = treeModel.getNodeOf((TestElement)this);
        if (myNode != null) {
            Enumeration kids = myNode.children();
            while (kids.hasMoreElements()) {
                TestElement testElement;
                JMeterTreeNode subNode = (JMeterTreeNode)kids.nextElement();
                if (!subNode.isEnabled() || !((testElement = subNode.getTestElement()) instanceof TestStateListener)) continue;
                TestBeanHelper.prepare((TestElement)testElement);
                ((TestStateListener)testElement).testStarted();
            }
        }
    }

    private void notifyTestListenersOfEnd() {
        JMeterTreeModel treeModel = this.getJmeterTreeModel();
        JMeterTreeNode myNode = treeModel.getNodeOf((TestElement)this);
        if (myNode != null) {
            Enumeration kids = myNode.children();
            while (kids.hasMoreElements()) {
                TestElement testElement;
                JMeterTreeNode subNode = (JMeterTreeNode)kids.nextElement();
                if (!subNode.isEnabled() || !((testElement = subNode.getTestElement()) instanceof TestStateListener)) continue;
                ((TestStateListener)testElement).testEnded();
            }
        }
    }

    public boolean canRemove() {
        return null == this.server;
    }

    private void initKeyStore() throws IOException, GeneralSecurityException {
        switch (KEYSTORE_MODE) {
            case DYNAMIC_KEYSTORE: {
                this.storePassword = this.getPassword();
                this.keyPassword = this.getPassword();
                this.initDynamicKeyStore();
                break;
            }
            case JMETER_KEYSTORE: {
                this.storePassword = this.getPassword();
                this.keyPassword = this.getPassword();
                this.initJMeterKeyStore();
                break;
            }
            case USER_KEYSTORE: {
                this.storePassword = JMeterUtils.getPropDefault((String)"proxy.cert.keystorepass", (String)DEFAULT_PASSWORD);
                this.keyPassword = JMeterUtils.getPropDefault((String)"proxy.cert.keypassword", (String)DEFAULT_PASSWORD);
                log.info("HTTP(S) Test Script Recorder will use the keystore '{}' with the alias: '{}'", (Object)CERT_PATH_ABS, (Object)CERT_ALIAS);
                this.initUserKeyStore();
                break;
            }
            case NONE: {
                throw new IOException("Cannot find keytool application and no keystore was provided");
            }
            default: {
                throw new IllegalStateException("Impossible case: " + (Object)((Object)KEYSTORE_MODE));
            }
        }
    }

    private void initUserKeyStore() {
        try {
            this.keyStore = this.getKeyStore(this.storePassword.toCharArray());
            X509Certificate caCert = (X509Certificate)this.keyStore.getCertificate(CERT_ALIAS);
            if (caCert == null) {
                log.error("Could not find key with alias {}", (Object)CERT_ALIAS);
                this.keyStore = null;
            } else {
                caCert.checkValidity(new Date(System.currentTimeMillis() + 86400000L));
            }
        }
        catch (Exception e) {
            this.keyStore = null;
            log.error("Could not open keystore or certificate is not valid {} {}", new Object[]{CERT_PATH_ABS, e.getMessage(), e});
        }
    }

    private void initDynamicKeyStore() throws IOException, GeneralSecurityException {
        String sslDomains;
        if (this.storePassword != null) {
            try {
                this.keyStore = this.getKeyStore(this.storePassword.toCharArray());
                for (String alias : KeyToolUtils.getCAaliases()) {
                    X509Certificate caCert = (X509Certificate)this.keyStore.getCertificate(alias);
                    if (caCert == null) {
                        this.keyStore = null;
                        break;
                    }
                    caCert.checkValidity(new Date(System.currentTimeMillis() + 86400000L));
                    log.info("Valid alias found for {}", (Object)alias);
                }
            }
            catch (IOException e) {
                this.keyStore = null;
                if (e.getCause() instanceof UnrecoverableKeyException) {
                    log.warn("Could not read key store {}; cause: {}, a new one will be created, ensure you install it in browser", new Object[]{e.getMessage(), e.getCause().getMessage(), e});
                } else {
                    log.warn("Could not open/read key store {}, a new one will be created, ensure you install it in browser", (Object)e.getMessage(), (Object)e);
                }
            }
            catch (CertificateExpiredException e) {
                this.keyStore = null;
                log.warn("Existing ROOT Certificate has expired, a new one will be created, ensure you install it in browser, message: {}", (Object)e.getMessage(), (Object)e);
            }
            catch (CertificateNotYetValidException e) {
                this.keyStore = null;
                log.warn("Existing ROOT Certificate is not yet valid, a new one will be created, ensure you install it in browser, message: {}", (Object)e.getMessage(), (Object)e);
            }
            catch (GeneralSecurityException e) {
                this.keyStore = null;
                log.warn("Problem reading key store, a new one will be created, ensure you install it in browser, message: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        if (this.keyStore == null) {
            this.keyPassword = this.storePassword = JOrphanUtils.generateRandomAlphanumericPassword((int)20);
            this.setPassword(this.storePassword);
            log.info("Creating HTTP(S) Test Script Recorder Root CA in {}, ensure you install certificate in your Browser for recording", (Object)CERT_PATH_ABS);
            KeyToolUtils.generateProxyCA((File)CERT_PATH, (String)this.storePassword, (int)CERT_VALIDITY);
            log.info("Created keystore in {}", (Object)CERT_PATH_ABS);
            this.keyStore = this.getKeyStore(this.storePassword.toCharArray());
        }
        if ((sslDomains = this.getSslDomains().trim()).length() > 0) {
            String[] domains;
            for (String subject : domains = sslDomains.split(",")) {
                if (this.isValid(subject)) {
                    if (this.keyStore.containsAlias(subject)) continue;
                    log.info("Creating entry {} in {}", (Object)subject, (Object)CERT_PATH_ABS);
                    KeyToolUtils.generateHostCert((File)CERT_PATH, (String)this.storePassword, (String)subject, (int)CERT_VALIDITY);
                    this.keyStore = this.getKeyStore(this.storePassword.toCharArray());
                    continue;
                }
                log.warn("Attempt to create an invalid domain certificate: {}", (Object)subject);
            }
        }
    }

    private boolean isValid(String subject) {
        String[] parts = subject.split("\\.");
        return !parts[0].endsWith("*") || parts.length >= 3 && AbstractVerifier.acceptableCountryWildcard((String)subject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    KeyStore updateKeyStore(String port, String host) throws IOException, GeneralSecurityException {
        File file = CERT_PATH;
        synchronized (file) {
            if (!this.keyStore.containsAlias(host)) {
                log.info("{} Creating entry {} in {}", new Object[]{port, host, CERT_PATH_ABS});
                KeyToolUtils.generateHostCert((File)CERT_PATH, (String)this.storePassword, (String)host, (int)CERT_VALIDITY);
            }
            this.keyStore = this.getKeyStore(this.storePassword.toCharArray());
        }
        return this.keyStore;
    }

    private void initJMeterKeyStore() throws IOException, GeneralSecurityException {
        if (this.storePassword != null) {
            try {
                this.keyStore = this.getKeyStore(this.storePassword.toCharArray());
                X509Certificate caCert = (X509Certificate)this.keyStore.getCertificate(JMETER_SERVER_ALIAS);
                caCert.checkValidity(new Date(System.currentTimeMillis() + 86400000L));
            }
            catch (Exception e) {
                this.keyStore = null;
                log.warn("Could not open expected file or certificate is not valid {} {}", new Object[]{CERT_PATH_ABS, e.getMessage(), e});
            }
        }
        if (this.keyStore == null) {
            this.keyPassword = this.storePassword = JOrphanUtils.generateRandomAlphanumericPassword((int)20);
            this.setPassword(this.storePassword);
            log.info("Generating standard keypair in {}", (Object)CERT_PATH_ABS);
            if (!CERT_PATH.delete()) {
                log.warn("Could not delete {}, this could create issues, stop jmeter, ensure file is deleted and restart again", (Object)CERT_PATH.getAbsolutePath());
            }
            KeyToolUtils.genkeypair((File)CERT_PATH, (String)JMETER_SERVER_ALIAS, (String)this.storePassword, (int)CERT_VALIDITY, null, null);
            this.keyStore = this.getKeyStore(this.storePassword.toCharArray());
        }
    }

    private KeyStore getKeyStore(char[] password) throws GeneralSecurityException, IOException {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(CERT_PATH));){
            log.debug("Opened Keystore file: {}", (Object)CERT_PATH_ABS);
            KeyStore ks = KeyStore.getInstance(KEYSTORE_TYPE);
            ks.load(in, password);
            log.debug("Loaded Keystore file: {}", (Object)CERT_PATH_ABS);
            KeyStore keyStore = ks;
            return keyStore;
        }
    }

    private String getPassword() {
        return PREFERENCES.get(USER_PASSWORD_KEY, null);
    }

    private void setPassword(String password) {
        PREFERENCES.put(USER_PASSWORD_KEY, password);
    }

    KeyStore getKeyStore() {
        return this.keyStore;
    }

    String getKeyPassword() {
        return this.keyPassword;
    }

    public static boolean isDynamicMode() {
        return KEYSTORE_MODE == KeystoreMode.DYNAMIC_KEYSTORE;
    }

    static {
        if (CERT_ALIAS != null) {
            KEYSTORE_MODE = KeystoreMode.USER_KEYSTORE;
            log.info("HTTP(S) Test Script Recorder will use the keystore '{}' with the alias: '{}'", (Object)CERT_PATH_ABS, (Object)CERT_ALIAS);
        } else if (!KeyToolUtils.haveKeytool()) {
            KEYSTORE_MODE = KeystoreMode.NONE;
        } else if (USE_DYNAMIC_KEYS) {
            KEYSTORE_MODE = KeystoreMode.DYNAMIC_KEYSTORE;
            log.info("HTTP(S) Test Script Recorder SSL Proxy will use keys that support embedded 3rd party resources in file {}", (Object)CERT_PATH_ABS);
        } else {
            KEYSTORE_MODE = KeystoreMode.JMETER_KEYSTORE;
            log.warn("HTTP(S) Test Script Recorder SSL Proxy will use keys that may not work for embedded resources in file {}", (Object)CERT_PATH_ABS);
        }
        USE_REDIRECT_DISABLING = JMeterUtils.getPropDefault((String)"proxy.redirect.disabling", (boolean)true);
        LAST_REDIRECT = null;
    }

    private static class SamplerInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private HTTPSamplerBase sampler;
        private transient TestElement[] testElements;
        private JMeterTreeNode target;
        private String prefix;
        private int groupingMode;
        private long recordedAt;

        public SamplerInfo(HTTPSamplerBase sampler, TestElement[] testElements, JMeterTreeNode target, String prefix, int groupingMode) {
            this.sampler = sampler;
            this.testElements = testElements;
            this.target = target;
            this.prefix = prefix;
            this.groupingMode = groupingMode;
            this.recordedAt = System.currentTimeMillis();
        }
    }

    public static enum KeystoreMode {
        USER_KEYSTORE,
        JMETER_KEYSTORE,
        DYNAMIC_KEYSTORE,
        NONE;

    }
}

