/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.gui;

import java.util.Iterator;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.config.Argument;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.config.gui.ArgumentsPanel;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.protocol.http.util.HTTPArgument;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.GuiUtils;
import org.apache.jorphan.gui.ObjectTableModel;
import org.apache.jorphan.reflect.Functor;

@TestElementMetadata(labelResource="user_defined_variables")
public class HTTPArgumentsPanel
extends ArgumentsPanel {
    private static final long serialVersionUID = 240L;
    private static final String ENCODE_OR_NOT = "encode?";
    private static final String INCLUDE_EQUALS = "include_equals";
    private static final String CONTENT_TYPE = "content_type";
    private static final String CLIPBOARD_LINE_DELIMITERS = "\n|&";
    private static final String CLIPBOARD_ARG_DELIMITERS = "\t|=";

    protected void initializeTableModel() {
        this.tableModel = new ObjectTableModel(new String[]{"name", "value", ENCODE_OR_NOT, CONTENT_TYPE, INCLUDE_EQUALS}, HTTPArgument.class, new Functor[]{new Functor("getName"), new Functor("getValue"), new Functor("isAlwaysEncoded"), new Functor("getContentType"), new Functor("isUseEquals")}, new Functor[]{new Functor("setName"), new Functor("setValue"), new Functor("setAlwaysEncoded"), new Functor("setContentType"), new Functor("setUseEquals")}, new Class[]{String.class, String.class, Boolean.class, String.class, Boolean.class});
    }

    public static boolean testFunctors() {
        HTTPArgumentsPanel instance = new HTTPArgumentsPanel();
        instance.initializeTableModel();
        return instance.tableModel.checkFunctors(null, ((Object)((Object)instance)).getClass());
    }

    protected void sizeColumns(JTable table) {
        GuiUtils.fixSize((TableColumn)table.getColumn(INCLUDE_EQUALS), (JTable)table);
        GuiUtils.fixSize((TableColumn)table.getColumn(ENCODE_OR_NOT), (JTable)table);
    }

    protected HTTPArgument makeNewArgument() {
        HTTPArgument arg = new HTTPArgument("", "");
        arg.setAlwaysEncoded(false);
        arg.setUseEquals(true);
        return arg;
    }

    public HTTPArgumentsPanel() {
        super(JMeterUtils.getResString((String)"paramtable"));
        this.init();
        this.clearBorderForMainPanel();
    }

    public TestElement createTestElement() {
        Arguments args = this.getUnclonedParameters();
        super.configureTestElement((TestElement)args);
        return (TestElement)args.clone();
    }

    public Arguments getParameters() {
        Arguments args = this.getUnclonedParameters();
        return (Arguments)args.clone();
    }

    private Arguments getUnclonedParameters() {
        this.stopTableEditing();
        Iterator modelData = this.tableModel.iterator();
        Arguments args = new Arguments();
        while (modelData.hasNext()) {
            HTTPArgument arg = (HTTPArgument)modelData.next();
            args.addArgument((Argument)arg);
        }
        return args;
    }

    public void configure(TestElement el) {
        super.configure(el);
        if (el instanceof Arguments) {
            this.tableModel.clearData();
            HTTPArgument.convertArgumentsToHTTP((Arguments)el);
            for (JMeterProperty jMeterProperty : ((Arguments)el).getArguments()) {
                HTTPArgument arg = (HTTPArgument)jMeterProperty.getObjectValue();
                this.tableModel.addRow((Object)arg);
            }
        }
        this.checkButtonsStatus();
    }

    protected boolean isMetaDataNormal(HTTPArgument arg) {
        return arg.getMetaData() == null || arg.getMetaData().equals("=") || arg.getValue() != null && arg.getValue().length() > 0;
    }

    protected void addFromClipboard() {
        this.addFromClipboard(CLIPBOARD_LINE_DELIMITERS, CLIPBOARD_ARG_DELIMITERS);
    }

    protected Argument createArgumentFromClipboard(String[] clipboardCols) {
        HTTPArgument argument = this.makeNewArgument();
        argument.setName(clipboardCols[0]);
        if (clipboardCols.length > 1) {
            argument.setValue(clipboardCols[1]);
            if (clipboardCols.length > 2) {
                argument.setAlwaysEncoded(Boolean.parseBoolean(clipboardCols[2].trim()));
                if (clipboardCols.length > 3) {
                    Boolean useEqual = BooleanUtils.toBooleanObject((String)clipboardCols[3].trim());
                    argument.setUseEquals(useEqual != null ? useEqual : true);
                }
            }
        }
        return argument;
    }

    private void init() {
        JTable table = this.getTable();
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem variabilizeItem = new JMenuItem(JMeterUtils.getResString((String)"transform_into_variable"));
        variabilizeItem.addActionListener(e -> this.transformNameIntoVariable());
        popupMenu.add(variabilizeItem);
        table.setComponentPopupMenu(popupMenu);
    }

    private void transformNameIntoVariable() {
        int[] rowsSelected;
        for (int selectedRow : rowsSelected = this.getTable().getSelectedRows()) {
            String name = (String)this.tableModel.getValueAt(selectedRow, 0);
            if (!StringUtils.isNotBlank((CharSequence)name)) continue;
            name = name.trim();
            name = name.replaceAll("\\$", "_");
            name = name.replaceAll("\\{", "_");
            name = name.replaceAll("\\}", "_");
            this.tableModel.setValueAt((Object)("${" + name + "}"), selectedRow, 1);
        }
    }
}

