/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.jdbc.processor;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.jmeter.protocol.jdbc.AbstractJDBCTestElement;
import org.apache.jmeter.protocol.jdbc.config.DataSourceElement;
import org.apache.jorphan.util.JOrphanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJDBCProcessor
extends AbstractJDBCTestElement {
    private static final Logger log = LoggerFactory.getLogger(AbstractJDBCProcessor.class);
    private static final long serialVersionUID = 233L;

    protected void process() {
        if (JOrphanUtils.isBlank((String)this.getDataSource())) {
            throw new IllegalArgumentException("Variable Name must not be null in " + this.getName());
        }
        try (Connection conn = DataSourceElement.getConnection(this.getDataSource());){
            this.execute(conn);
        }
        catch (SQLException ex) {
            log.warn("SQL Problem in {}: {}", (Object)this.getName(), (Object)ex.toString());
        }
        catch (IOException ex) {
            log.warn("IO Problem in {}: {}" + this.getName(), (Object)ex.toString());
        }
        catch (UnsupportedOperationException ex) {
            log.warn("Execution Problem in {}: {}", (Object)this.getName(), (Object)ex.toString());
        }
    }
}

