/// <reference types="node" />
import FormData from 'form-data';
import { HttpClientResponse, HttpMethod } from 'urllib';
import { URLSearchParams } from 'url';
import { AdapterOption } from './adapter';
import { Throttle } from 'stream-throttle';
import { UplogEntry } from './uplog';
import { RequestStats, URLRequestOptions } from './http-client';
export declare type HttpProtocol = "http" | "https";
export interface RequestOptions {
    method?: HttpMethod;
    path?: string;
    query?: URLSearchParams;
    bucketName?: string;
    s3RegionId?: string;
    serviceName: ServiceName;
    data?: any;
    dataType?: string;
    form?: FormData;
    contentType?: string;
    headers?: {
        [headerName: string]: string;
    };
    uploadProgress?: (uploaded: number, total: number) => void;
    uploadThrottle?: Throttle;
    stats?: RequestStats;
}
export interface SharedRequestOptions extends AdapterOption {
    protocol?: HttpProtocol;
    timeout?: number | number[];
    userAgent?: string;
    retry?: number;
    retryDelay?: number;
}
export declare class KodoHttpClient {
    private readonly sharedOptions;
    private readonly regionsCache;
    private readonly regionsCacheLock;
    private readonly regionService;
    private static logClientId;
    private readonly uplogBuffer;
    private readonly httpClient;
    constructor(sharedOptions: SharedRequestOptions);
    call<T = any>(options: RequestOptions): Promise<HttpClientResponse<T>>;
    callUrls<T = any>(urls: Array<string>, options: URLRequestOptions): Promise<HttpClientResponse<T>>;
    clearCache(): void;
    private getServiceUrls;
    log(entry: UplogEntry): Promise<void>;
    private sendUplog;
    private getUrlsFromRegion;
}
export declare enum ServiceName {
    Up = 0,
    Uc = 1,
    Rs = 2,
    Rsf = 3,
    Api = 4,
    S3 = 5,
    Qcdn = 6,
    Portal = 7,
    Uplog = 8
}
//# sourceMappingURL=kodo-http-client.d.ts.map