"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.signPrivateURL = exports.makeUploadToken = exports.newUploadPolicy = exports.generateAccessTokenV2 = exports.base64ToUrlSafe = void 0;
const crypto_1 = require("crypto");
const url_1 = require("url");
const js_base64_1 = require("js-base64");
function hmacSha1(data, secretKey) {
    const hmac = crypto_1.createHmac('sha1', secretKey);
    hmac.update(data);
    return hmac.digest('base64');
}
function base64ToUrlSafe(v) {
    return v.replace(/\//g, '_').replace(/\+/g, '-');
}
exports.base64ToUrlSafe = base64ToUrlSafe;
function generateAccessTokenV2(accessKey, secretKey, requestURI, requestMethod, contentType, requestBody) {
    const url = new url_1.URL(requestURI);
    let data = `${requestMethod} ${url.pathname}${url.search}\nHost: ${url.host}\n`;
    contentType = contentType !== null && contentType !== void 0 ? contentType : '';
    if (contentType === 'application/json' || contentType === 'application/x-www-form-urlencoded') {
        data += `Content-Type: ${contentType}\n`;
    }
    requestBody = requestBody !== null && requestBody !== void 0 ? requestBody : '';
    data += `\n${requestBody}`;
    return `Qiniu ${accessKey}:${base64ToUrlSafe(hmacSha1(data, secretKey))}`;
}
exports.generateAccessTokenV2 = generateAccessTokenV2;
function newUploadPolicy(bucket, key, deadline) {
    let scope = bucket;
    if (key) {
        scope += `:${key}`;
    }
    deadline !== null && deadline !== void 0 ? deadline : (deadline = new Date(Date.now() + 7 * 24 * 60 * 60 * 1000));
    return {
        scope: scope,
        deadline: ~~(deadline.getTime() / 1000),
    };
}
exports.newUploadPolicy = newUploadPolicy;
function makeUploadToken(accessKey, secretKey, uploadPolicy) {
    const data = base64ToUrlSafe(js_base64_1.encode(JSON.stringify(uploadPolicy)));
    const sign = base64ToUrlSafe(hmacSha1(data, secretKey));
    return `${accessKey}:${sign}:${data}`;
}
exports.makeUploadToken = makeUploadToken;
function signPrivateURL(accessKey, secretKey, baseURL, deadline) {
    let baseURLString = baseURL.toString();
    deadline !== null && deadline !== void 0 ? deadline : (deadline = new Date(Date.now() + 7 * 24 * 60 * 60 * 1000));
    const deadlineTimestamp = ~~(deadline.getTime() / 1000);
    baseURLString += `?e=${deadlineTimestamp}`;
    const sign = base64ToUrlSafe(hmacSha1(baseURLString, secretKey));
    const token = `${accessKey}:${sign}`;
    baseURLString += `&token=${token}`;
    return new url_1.URL(baseURLString);
}
exports.signPrivateURL = signPrivateURL;
//# sourceMappingURL=kodo-auth.js.map