# Installation
> `npm install --save @types/stream-throttle`

# Summary
This package contains type definitions for stream-throttle (https://github.com/tjgq/node-stream-throttle).

# Details
Files were exported from https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/stream-throttle.
## [index.d.ts](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/stream-throttle/index.d.ts)
````ts
// Type definitions for stream-throttle 0.1
// Project: https://github.com/tjgq/node-stream-throttle
// Definitions by: Daniel Byrne <https://github.com/danwbyrne>
// Definitions: https://github.com/DefinitelyTyped/DefinitelyTyped

/// <reference types = "node" />

import { Transform } from 'stream';

export interface ThrottleOptions {
  readonly rate: number;
  readonly chunksize?: number | undefined;
}

export class Throttle extends Transform {
  constructor(options: ThrottleOptions);
}

export class ThrottleGroup {
  constructor(options: ThrottleOptions);
  throttle(options: ThrottleOptions): Throttle;
}

````

### Additional Details
 * Last updated: Fri, 02 Jul 2021 22:33:00 GMT
 * Dependencies: [@types/node](https://npmjs.com/package/@types/node)
 * Global values: none

# Credits
These definitions were written by [Daniel Byrne](https://github.com/danwbyrne).
