/**
 * Note: not all of these are currently implemented.
 *
 * Source: https://msdn.microsoft.com/en-us/library/windows/desktop/ms724884(v=vs.85).aspx
 */
export declare enum RegistryValueType {
    REG_BINARY = "REG_BINARY",
    REG_DWORD = "REG_DWORD",
    REG_DWORD_LITTLE_ENDIAN = "REG_DWORD_LITTLE_ENDIAN",
    REG_DWORD_BIG_ENDIAN = "REG_DWORD_BIG_ENDIAN",
    REG_EXPAND_SZ = "REG_EXPAND_SZ",
    REG_LINK = "REG_LINK",
    REG_MULTI_SZ = "REG_MULTI_SZ",
    REG_NONE = "REG_NONE",
    REG_QWORD = "REG_QWORD",
    REG_QWORD_LITTLE_ENDIAN = "REG_QWORD_LITTLE_ENDIAN",
    REG_SZ = "REG_SZ"
}
export declare type RegistryStringEntry = {
    readonly name: string;
    readonly type: RegistryValueType.REG_SZ | RegistryValueType.REG_EXPAND_SZ;
    readonly data: string;
};
export declare type RegistryNumberEntry = {
    readonly name: string;
    readonly type: RegistryValueType.REG_DWORD;
    readonly data: number;
};
export declare type RegistryValue = RegistryStringEntry | RegistryNumberEntry;
export declare enum HKEY {
    HKEY_CLASSES_ROOT = "HKEY_CLASSES_ROOT",
    HKEY_CURRENT_CONFIG = "HKEY_CURRENT_CONFIG",
    HKEY_DYN_DATA = "HKEY_DYN_DATA",
    HKEY_CURRENT_USER_LOCAL_SETTINGS = "HKEY_CURRENT_USER_LOCAL_SETTINGS",
    HKEY_CURRENT_USER = "HKEY_CURRENT_USER",
    HKEY_LOCAL_MACHINE = "HKEY_LOCAL_MACHINE",
    HKEY_PERFORMANCE_DATA = "HKEY_PERFORMANCE_DATA",
    HKEY_PERFORMANCE_TEXT = "HKEY_PERFORMANCE_TEXT",
    HKEY_PERFORMANCE_NLSTEXT = "HKEY_PERFORMANCE_NLSTEXT",
    HKEY_USERS = "HKEY_USERS"
}
export declare function enumerateValues(key: HKEY, subkey: string): ReadonlyArray<RegistryValue>;
export declare function enumerateValuesSafe(key: HKEY, subkey: string): ReadonlyArray<RegistryValue>;
export declare function enumerateKeys(key: HKEY, subkey?: string | null): ReadonlyArray<string>;
export declare function enumerateKeysSafe(key: HKEY, subkey?: string | null): ReadonlyArray<string>;
export declare function createKey(key: HKEY, subkey: string): boolean;
export declare function createKeySafe(key: HKEY, subkey: string): boolean;
export declare function setValue(key: HKEY, subkey: string, valueName: string, valueType: RegistryValueType, valueData: string): boolean;
export declare function setValueSafe(key: HKEY, subkey: string, valueName: string, valueType: RegistryValueType, valueData: string): boolean;
