/// <reference types="node" />
import { Adapter, SetObjectHeader, Part, ProgressCallback, Object } from './adapter';
import { FileHandle } from 'fs/promises';
import { ThrottleGroup, ThrottleOptions } from 'stream-throttle';
export declare class Uploader {
    private readonly adapter;
    private aborted;
    private static readonly userCanceledError;
    constructor(adapter: Adapter);
    putObjectFromFile(region: string, object: Object, file: FileHandle, fileSize: number, originalFileName: string, putFileOption?: PutFileOption): Promise<void>;
    abort(): void;
    private putObject;
    private initParts;
    private uploadParts;
}
export interface PutCallback {
    progressCallback?: ProgressCallback;
    partsInitCallback?: (initInfo: RecoveredOption) => void;
    partPutCallback?: (part: Part) => void;
}
export interface PutFileOption {
    header?: SetObjectHeader;
    recovered?: RecoveredOption;
    putCallback?: PutCallback;
    partSize?: number;
    uploadThreshold?: number;
    uploadThrottleGroup?: ThrottleGroup;
    uploadThrottleOption?: ThrottleOptions;
}
export interface RecoveredOption {
    uploadId: string;
    parts: Array<Part>;
}
//# sourceMappingURL=uploader.d.ts.map