/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.jmdns.NetworkTopologyListener;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import javax.jmdns.ServiceTypeListener;
import javax.jmdns.impl.JmmDNSImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface JmmDNS
extends Closeable {
    public String[] getNames();

    public String[] getHostNames();

    public InetAddress[] getInterfaces() throws IOException;

    public ServiceInfo[] getServiceInfos(String var1, String var2);

    public ServiceInfo[] getServiceInfos(String var1, String var2, long var3);

    public ServiceInfo[] getServiceInfos(String var1, String var2, boolean var3);

    public ServiceInfo[] getServiceInfos(String var1, String var2, boolean var3, long var4);

    public void requestServiceInfo(String var1, String var2);

    public void requestServiceInfo(String var1, String var2, boolean var3);

    public void requestServiceInfo(String var1, String var2, long var3);

    public void requestServiceInfo(String var1, String var2, boolean var3, long var4);

    public void addServiceTypeListener(ServiceTypeListener var1) throws IOException;

    public void removeServiceTypeListener(ServiceTypeListener var1);

    public void addServiceListener(String var1, ServiceListener var2);

    public void removeServiceListener(String var1, ServiceListener var2);

    public void registerService(ServiceInfo var1) throws IOException;

    public void unregisterService(ServiceInfo var1);

    public void unregisterAllServices();

    public void registerServiceType(String var1);

    public ServiceInfo[] list(String var1);

    public ServiceInfo[] list(String var1, long var2);

    public Map<String, ServiceInfo[]> listBySubtype(String var1);

    public Map<String, ServiceInfo[]> listBySubtype(String var1, long var2);

    public void addNetworkTopologyListener(NetworkTopologyListener var1);

    public void removeNetworkTopologyListener(NetworkTopologyListener var1);

    public NetworkTopologyListener[] networkListeners();

    public static final class Factory {
        private static volatile JmmDNS _instance;
        private static final AtomicReference<ClassDelegate> _databaseClassDelegate;

        private Factory() {
        }

        public static void setClassDelegate(ClassDelegate delegate) {
            _databaseClassDelegate.set(delegate);
        }

        public static ClassDelegate classDelegate() {
            return _databaseClassDelegate.get();
        }

        protected static JmmDNS newJmmDNS() {
            JmmDNS dns = null;
            ClassDelegate delegate = _databaseClassDelegate.get();
            if (delegate != null) {
                dns = delegate.newJmmDNS();
            }
            return dns != null ? dns : new JmmDNSImpl();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static JmmDNS getInstance() {
            if (_instance != null) return _instance;
            Class<Factory> clazz = Factory.class;
            synchronized (Factory.class) {
                if (_instance != null) return _instance;
                _instance = Factory.newJmmDNS();
                // ** MonitorExit[var0] (shouldn't be in output)
                return _instance;
            }
        }

        static {
            _databaseClassDelegate = new AtomicReference();
        }

        public static interface ClassDelegate {
            public JmmDNS newJmmDNS();
        }
    }
}

