/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.modules.upstart_slave_installer;

import hudson.Util;
import hudson.model.TaskListener;
import hudson.os.SU;
import hudson.remoting.Callable;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.modules.slave_installer.AbstractUnixSlaveInstaller;
import org.jenkinsci.modules.slave_installer.InstallationException;
import org.jenkinsci.modules.slave_installer.LaunchConfiguration;
import org.jenkinsci.modules.slave_installer.Prompter;
import org.jenkinsci.modules.upstart_slave_installer.Messages;
import org.jvnet.localizer.Localizable;

public class UpstartSlaveInstaller
extends AbstractUnixSlaveInstaller {
    private final String instanceId;

    public UpstartSlaveInstaller(String instanceId) {
        this.instanceId = instanceId;
    }

    public Localizable getConfirmationText() {
        return Messages._UpstartSlaveInstaller_ConfirmationText();
    }

    public void install(LaunchConfiguration params, Prompter prompter) throws InstallationException, IOException, InterruptedException {
        final File srcSlaveJar = params.getJarFile();
        final String args = params.buildRunnerArguments().toStringWithQuote();
        final File rootDir = params.getStorage().getAbsoluteFile();
        final StreamTaskListener listener = StreamTaskListener.fromStdout();
        final String userName = this.getCurrentUnixUserName();
        String rootUser = prompter.prompt("Specify the super user name to 'sudo' to", "root");
        String rootPassword = prompter.promptPassword("Specify your password for sudo (or empty if you can sudo without password)");
        SU.execute((TaskListener)listener, (String)rootUser, (String)rootPassword, (Callable)new Callable<Void, IOException>(){

            public Void call() throws IOException {
                try {
                    File slaveJar = new File(rootDir, "slave.jar");
                    FileUtils.copyFile((File)srcSlaveJar, (File)slaveJar);
                    String conf = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("jenkins-slave.conf"));
                    conf = conf.replace("{username}", userName).replace("{jar}", slaveJar.getAbsolutePath()).replace("{args}", args);
                    String name = "jenkins-slave-" + UpstartSlaveInstaller.this.instanceId;
                    FileUtils.writeStringToFile((File)new File("/etc/init/" + name + ".conf"), (String)conf);
                    Util.createSymlink((File)new File("/etc/init.d"), (String)"/lib/init/upstart-job", (String)name, (TaskListener)listener);
                    Process p = new ProcessBuilder("initctl", "start", name).redirectErrorStream(true).start();
                    p.getOutputStream().close();
                    IOUtils.copy((InputStream)p.getInputStream(), (OutputStream)listener.getLogger());
                    int r = p.waitFor();
                    if (r != 0) {
                        throw new IOException("Failed to launch  a service: " + r);
                    }
                    return null;
                }
                catch (InterruptedException e) {
                    throw (InterruptedIOException)new InterruptedIOException().initCause(e);
                }
            }
        });
        System.exit(0);
    }
}

