/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.userdetails.ldap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.ldap.Control;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.userdetails.ldap.LdapUserDetails;
import org.springframework.util.Assert;

public class LdapUserDetailsImpl
implements LdapUserDetails {
    private static final long serialVersionUID = 1L;
    private static final GrantedAuthority[] NO_AUTHORITIES = new GrantedAuthority[0];
    private static final Control[] NO_CONTROLS = new Control[0];
    private Attributes attributes = new BasicAttributes();
    private String dn;
    private String password;
    private String username;
    private GrantedAuthority[] authorities = NO_AUTHORITIES;
    private Control[] controls = NO_CONTROLS;
    private boolean accountNonExpired = true;
    private boolean accountNonLocked = true;
    private boolean credentialsNonExpired = true;
    private boolean enabled = true;

    protected LdapUserDetailsImpl() {
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public GrantedAuthority[] getAuthorities() {
        return this.authorities;
    }

    public Control[] getControls() {
        return this.controls;
    }

    public String getDn() {
        return this.dn;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isAccountNonExpired() {
        return this.accountNonExpired;
    }

    public boolean isAccountNonLocked() {
        return this.accountNonLocked;
    }

    public boolean isCredentialsNonExpired() {
        return this.credentialsNonExpired;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    static /* synthetic */ GrantedAuthority[] access$002(LdapUserDetailsImpl x0, GrantedAuthority[] x1) {
        x0.authorities = x1;
        return x1;
    }

    static /* synthetic */ Control[] access$402(LdapUserDetailsImpl x0, Control[] x1) {
        x0.controls = x1;
        return x1;
    }

    public static class Essence {
        private LdapUserDetailsImpl instance = this.createTarget();
        private List mutableAuthorities = new ArrayList();

        public Essence() {
        }

        public Essence(LdapUserDetails copyMe) {
            this.setDn(copyMe.getDn());
            this.setAttributes(copyMe.getAttributes());
            this.setUsername(copyMe.getUsername());
            this.setPassword(copyMe.getPassword());
            this.setEnabled(copyMe.isEnabled());
            this.setAccountNonExpired(copyMe.isAccountNonExpired());
            this.setCredentialsNonExpired(copyMe.isCredentialsNonExpired());
            this.setAccountNonLocked(copyMe.isAccountNonLocked());
            this.setControls(copyMe.getControls());
            this.setAuthorities(copyMe.getAuthorities());
        }

        LdapUserDetailsImpl createTarget() {
            return new LdapUserDetailsImpl();
        }

        public Essence addAuthority(GrantedAuthority a) {
            this.mutableAuthorities.add(a);
            return this;
        }

        public LdapUserDetails createUserDetails() {
            Assert.notNull((Object)this.instance, (String)"Essence can only be used to create a single instance");
            LdapUserDetailsImpl.access$002(this.instance, this.getGrantedAuthorities());
            LdapUserDetailsImpl newInstance = this.instance;
            this.instance = null;
            return newInstance;
        }

        public GrantedAuthority[] getGrantedAuthorities() {
            return this.mutableAuthorities.toArray(new GrantedAuthority[0]);
        }

        public Essence setAccountNonExpired(boolean accountNonExpired) {
            this.instance.accountNonExpired = accountNonExpired;
            return this;
        }

        public Essence setAccountNonLocked(boolean accountNonLocked) {
            this.instance.accountNonLocked = accountNonLocked;
            return this;
        }

        public Essence setAttributes(Attributes attributes) {
            this.instance.attributes = attributes;
            return this;
        }

        public Essence setAuthorities(GrantedAuthority[] authorities) {
            this.mutableAuthorities = new ArrayList<GrantedAuthority>(Arrays.asList(authorities));
            return this;
        }

        public void setControls(Control[] controls) {
            LdapUserDetailsImpl.access$402(this.instance, controls);
        }

        public Essence setCredentialsNonExpired(boolean credentialsNonExpired) {
            this.instance.credentialsNonExpired = credentialsNonExpired;
            return this;
        }

        public Essence setDn(String dn) {
            this.instance.dn = dn;
            return this;
        }

        public Essence setEnabled(boolean enabled) {
            this.instance.enabled = enabled;
            return this;
        }

        public Essence setPassword(String password) {
            this.instance.password = password;
            return this;
        }

        public Essence setUsername(String username) {
            this.instance.username = username;
            return this;
        }
    }
}

