/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.putty;

import com.trilead.ssh2.crypto.Base64;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigInteger;

final class DEREncoder {
    private final DataOutputStream out;
    private final ByteArrayOutputStream baos = new ByteArrayOutputStream();

    public DEREncoder() {
        this.out = new DataOutputStream(this.baos);
    }

    public void reset() {
        this.baos.reset();
    }

    public byte[] toByteArray() {
        return this.baos.toByteArray();
    }

    public String toBase64() {
        char[] r = Base64.encode((byte[])this.toByteArray());
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < r.length; ++i) {
            buf.append(r[i]);
            if (i % 64 != 63) continue;
            buf.append('\n');
        }
        if (r.length % 64 != 0) {
            buf.append('\n');
        }
        return buf.toString();
    }

    public DEREncoder writeSequence(byte[] data, int offset, int length) throws IOException {
        this.out.write(48);
        this.writeLength(length);
        this.out.write(data, offset, length);
        return this;
    }

    public DEREncoder writeSequence(byte[] data) throws IOException {
        return this.writeSequence(data, 0, data.length);
    }

    public void writeLength(int len) throws IOException {
        if (len < 128) {
            this.out.write(len);
            return;
        }
        int bytes = this.countByteLen(len);
        this.out.write(0x80 | bytes);
        for (int i = bytes - 1; i >= 0; --i) {
            this.out.write(len >> 8 * i & 0xFF);
        }
    }

    private int countByteLen(int len) {
        int bytes = 0;
        while (len > 0) {
            ++bytes;
            len >>= 8;
        }
        return bytes;
    }

    public DEREncoder write(BigInteger i) throws IOException {
        this.out.write(2);
        byte[] bytes = i.toByteArray();
        this.writeLength(bytes.length);
        this.out.write(bytes);
        return this;
    }

    public DEREncoder write(BigInteger ... ints) throws IOException {
        for (BigInteger i : ints) {
            this.write(i);
        }
        return this;
    }
}

