/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl.parser;

import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.parser.ASTIdentifier;
import org.apache.commons.jexl.parser.Parser;
import org.apache.commons.jexl.parser.ParserVisitor;
import org.apache.commons.jexl.parser.SimpleNode;
import org.apache.commons.jexl.util.introspection.Info;
import org.apache.commons.jexl.util.introspection.VelMethod;

public class ASTMethod
extends SimpleNode {
    private static final Info DUMMY = new Info("", 1, 1);

    public ASTMethod(int id) {
        super(id);
    }

    public ASTMethod(Parser p, int id) {
        super(p, id);
    }

    public Object jjtAccept(ParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public Object execute(Object obj, JexlContext jc) throws Exception {
        String methodName = ((ASTIdentifier)this.jjtGetChild((int)0)).val;
        int paramCount = this.jjtGetNumChildren() - 1;
        Object[] params = new Object[paramCount];
        try {
            for (int i = 0; i < paramCount; ++i) {
                params[i] = ((SimpleNode)this.jjtGetChild(i + 1)).value(jc);
            }
            VelMethod vm = this.getUberspect().getMethod(obj, methodName, params, DUMMY);
            if (vm == null) {
                for (int i = 0; i < params.length; ++i) {
                    Object param = params[i];
                    if (!(param instanceof Number)) continue;
                    params[i] = this.narrow((Number)param);
                }
                vm = this.getUberspect().getMethod(obj, methodName, params, DUMMY);
                if (vm == null) {
                    return null;
                }
            }
            return vm.invoke(obj, params);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw e;
        }
    }

    private Number narrow(Number original) {
        if (original == null || original instanceof BigDecimal || original instanceof BigInteger) {
            return original;
        }
        Number result = original;
        if (original instanceof Double || original instanceof Float) {
            double value = original.doubleValue();
            if (value <= 3.4028234663852886E38 && value >= (double)1.4E-45f) {
                result = new Float(result.floatValue());
            }
        } else {
            long value = original.longValue();
            if (value <= 127L && value >= -128L) {
                result = new Byte((byte)value);
            } else if (value <= 32767L && value >= -32768L) {
                result = new Short((short)value);
            } else if (value <= Integer.MAX_VALUE && value >= Integer.MIN_VALUE) {
                result = new Integer((int)value);
            }
        }
        return result;
    }
}

