/*
 * Decompiled with CFR 0.152.
 */
package com.sun.akuma;

import com.sun.akuma.CLibrary;
import com.sun.akuma.Daemon;
import com.sun.akuma.JavaVMArguments;
import com.sun.jna.StringArray;
import java.io.FileDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketImpl;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public abstract class NetworkServer
extends Daemon {
    protected final List<String> arguments;
    private static final Logger LOGGER = Logger.getLogger(NetworkServer.class.getName());
    private static final int SIGTERM = 15;
    private static final String MODE_PROPERTY = NetworkServer.class.getName() + ".mode";

    protected NetworkServer(String[] args) {
        this.arguments = Collections.unmodifiableList(Arrays.asList(args));
    }

    public void run() throws Exception {
        String mode = System.getProperty(MODE_PROPERTY);
        if ("worker".equals(mode)) {
            this.worker();
        } else {
            if (this.isDaemonized()) {
                this.init();
            } else if (this.shouldBeDaemonized()) {
                this.daemonize();
                System.exit(0);
            }
            this.frontend();
        }
    }

    protected boolean shouldBeDaemonized() {
        return !this.arguments.isEmpty() && this.arguments.get(0).equals("daemonize");
    }

    protected void frontend() throws Exception {
        ServerSocket ss = this.createServerSocket();
        int fdn = this.getUnixFileDescriptor(ss);
        LOGGER.fine("Listening to port " + ss.getLocalPort() + " (fd=" + fdn + ")");
        JavaVMArguments forkArgs = JavaVMArguments.current();
        forkArgs.setSystemProperty(NetworkServer.class.getName() + ".port", String.valueOf(fdn));
        this.forkWorkers(forkArgs);
    }

    protected abstract void forkWorkers(JavaVMArguments var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forkWorkerThreads(JavaVMArguments arguments, int n) throws Exception {
        Object o;
        String exe = Daemon.getCurrentExecutable();
        arguments.setSystemProperty(MODE_PROPERTY, "worker");
        LOGGER.fine("Forking worker: " + arguments);
        StringArray sa = arguments.toStringArray();
        for (int i = 0; i < n; ++i) {
            int r = CLibrary.LIBC.fork();
            if (r < 0) {
                CLibrary.LIBC.perror("forking a worker process failed");
                System.exit(-1);
            }
            if (r != 0) continue;
            CLibrary.LIBC.execv(exe, sa);
            System.err.println("exec failed");
            CLibrary.LIBC.perror("initial exec failed");
            System.exit(-1);
        }
        Signal.handle(new Signal("TERM"), new SignalHandler(){

            public void handle(Signal sig) {
                CLibrary.LIBC.kill(0, 15);
                System.exit(-1);
            }
        });
        Object object = o = new Object();
        synchronized (object) {
            o.wait();
        }
    }

    protected abstract ServerSocket createServerSocket() throws Exception;

    private int getUnixFileDescriptor(ServerSocket ss) throws NoSuchFieldException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Field $impl = ss.getClass().getDeclaredField("impl");
        $impl.setAccessible(true);
        SocketImpl socketImpl = (SocketImpl)$impl.get(ss);
        Method $getFileDescriptor = SocketImpl.class.getDeclaredMethod("getFileDescriptor", new Class[0]);
        $getFileDescriptor.setAccessible(true);
        FileDescriptor fd = (FileDescriptor)$getFileDescriptor.invoke((Object)socketImpl, new Object[0]);
        Field $fd = fd.getClass().getDeclaredField("fd");
        $fd.setAccessible(true);
        return (Integer)$fd.get(fd);
    }

    protected void worker() throws Exception {
        String port = System.getProperty(NetworkServer.class.getName() + ".port");
        this.worker(this.recreateServerSocket(Integer.parseInt(port)));
    }

    protected abstract void worker(ServerSocket var1) throws Exception;

    private ServerSocket recreateServerSocket(int fdn) throws Exception {
        FileDescriptor fd = new FileDescriptor();
        Field $fd = FileDescriptor.class.getDeclaredField("fd");
        $fd.setAccessible(true);
        $fd.set(fd, fdn);
        Class<?> $PlainSocketImpl = Class.forName("java.net.PlainSocketImpl");
        Constructor<?> $init = $PlainSocketImpl.getDeclaredConstructor(FileDescriptor.class);
        $init.setAccessible(true);
        SocketImpl socketImpl = (SocketImpl)$init.newInstance(fd);
        ServerSocket ss = new ServerSocket();
        ss.bind(new InetSocketAddress(0));
        Field $impl = ServerSocket.class.getDeclaredField("impl");
        $impl.setAccessible(true);
        $impl.set(ss, socketImpl);
        return ss;
    }
}

