/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.solaris.libzfs;

import org.jvnet.solaris.libzfs.ZFSFileSystem;
import org.jvnet.solaris.libzfs.ZFSObject;
import org.jvnet.solaris.libzfs.ZFSSnapshot;
import org.jvnet.solaris.libzfs.ZFSVolume;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ZFSType {
    FILESYSTEM(1, ZFSFileSystem.class),
    SNAPSHOT(2, ZFSSnapshot.class),
    VOLUME(4, ZFSVolume.class);

    public final int code;
    public final Class<? extends ZFSObject> type;

    private ZFSType(int code, Class<? extends ZFSObject> type) {
        this.code = code;
        this.type = type;
    }

    static ZFSType fromCode(int n) {
        for (ZFSType t : (ZFSType[])ZFSType.class.getEnumConstants()) {
            if (t.code != n) continue;
            return t;
        }
        return null;
    }

    static ZFSType fromType(Class<? extends ZFSObject> subType) {
        for (ZFSType t : (ZFSType[])ZFSType.class.getEnumConstants()) {
            if (t.type != subType) continue;
            return t;
        }
        return null;
    }
}

