/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.solaris.libzfs;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.jvnet.solaris.jna.PtrByReference;
import org.jvnet.solaris.libzfs.ZFSException;
import org.jvnet.solaris.libzfs.ZFSObject;
import org.jvnet.solaris.libzfs.ZFSPermission;
import org.jvnet.solaris.libzfs.jna.libzfs;
import org.jvnet.solaris.libzfs.jna.zfs_deleg_who_type_t;
import org.jvnet.solaris.nvlist.jna.nvlist_t;

public class ACLBuilder {
    final Set<PermissionBuilder> builders = new HashSet<PermissionBuilder>();

    public PermissionBuilder everyone() {
        return this.add(new PermissionBuilder(zfs_deleg_who_type_t.ZFS_DELEG_EVERYONE));
    }

    public PermissionBuilder user(final String userName) {
        return this.add(new PermissionBuilder(zfs_deleg_who_type_t.ZFS_DELEG_USER){

            protected String who() {
                return userName;
            }
        });
    }

    public PermissionBuilder group(final String groupName) {
        return this.add(new PermissionBuilder(zfs_deleg_who_type_t.ZFS_DELEG_GROUP){

            protected String who() {
                return groupName;
            }
        });
    }

    private PermissionBuilder add(PermissionBuilder pb) {
        this.builders.add(pb);
        return pb;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PermissionBuilder {
        private final zfs_deleg_who_type_t whoType;
        protected char inheritanceBits = '\u0000';
        private final Set<ZFSPermission> permissions = EnumSet.noneOf(ZFSPermission.class);

        private PermissionBuilder(zfs_deleg_who_type_t whoType) {
            this.whoType = whoType;
        }

        public PermissionBuilder onThisDataset() {
            this.inheritanceBits = (char)(this.inheritanceBits | '\u0001');
            return this;
        }

        public PermissionBuilder onDescendants() {
            this.inheritanceBits = (char)(this.inheritanceBits | 2);
            return this;
        }

        public PermissionBuilder onNewDataset() {
            this.inheritanceBits = (char)(this.inheritanceBits | 4);
            return this;
        }

        public PermissionBuilder with(ZFSPermission ... args) {
            return this.with(Arrays.asList(args));
        }

        public PermissionBuilder with(ZFSPermission arg) {
            this.permissions.add(arg);
            return this;
        }

        public PermissionBuilder with(Collection<ZFSPermission> arg) {
            this.permissions.addAll(arg);
            return this;
        }

        public PermissionBuilder withEverything() {
            return this.with(EnumSet.allOf(ZFSPermission.class));
        }

        protected String who() {
            return null;
        }

        protected nvlist_t toNativeFormat(ZFSObject dataset) {
            StringBuilder buf = new StringBuilder();
            for (ZFSPermission p : this.permissions) {
                if (buf.length() > 0) {
                    buf.append(',');
                }
                buf.append((Object)p);
            }
            if (this.inheritanceBits == '\u0000') {
                this.inheritanceBits = (char)3;
            }
            PtrByReference<nvlist_t> r = new PtrByReference<nvlist_t>();
            if (libzfs.LIBZFS.zfs_build_perms(dataset.handle, this.who(), buf.toString().toLowerCase(), this.whoType.code, this.inheritanceBits, r) != 0) {
                throw new ZFSException(dataset.library);
            }
            return r.getValue(nvlist_t.class);
        }
    }
}

