/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.robust_http_client;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;

public class RetryableHttpStream
extends InputStream {
    public final URL url;
    protected final Proxy proxy;
    public final int totalLength;
    protected int read;
    private InputStream in;
    public final HttpURLConnection connection;
    private int nRetry;

    public RetryableHttpStream(URL url) throws IOException {
        this(url, null);
    }

    public RetryableHttpStream(URL url, Proxy proxy) throws IOException {
        this.url = url;
        if (!url.getProtocol().startsWith("http")) {
            throw new IllegalArgumentException(url + " is not an HTTP URL");
        }
        this.proxy = proxy;
        this.connection = this.connect();
        this.totalLength = this.connection.getContentLength();
        this.in = this.getStream(this.connection);
    }

    InputStream getStream(HttpURLConnection con) throws IOException {
        return con.getInputStream();
    }

    protected HttpURLConnection connect() throws IOException {
        return (HttpURLConnection)(this.proxy != null ? this.url.openConnection(this.proxy) : this.url.openConnection());
    }

    private void reconnect() throws IOException {
        block0: while (true) {
            long l;
            this.shallWeRetry();
            HttpURLConnection con = this.connect();
            con.setRequestProperty("Range", "bytes=" + this.read + "-");
            con.connect();
            String cr = con.getHeaderField("Content-Range");
            this.in = this.getStream(con);
            if (cr != null && cr.startsWith("bytes " + this.read + "-")) {
                return;
            }
            int bytesToSkip = this.read;
            do {
                if ((l = this.in.skip(bytesToSkip)) == 0L) continue block0;
            } while ((bytesToSkip = (int)((long)bytesToSkip - l)) != 0);
            break;
        }
    }

    protected void shallWeRetry() throws IOException {
        if (this.nRetry++ > 5) {
            throw new IOException("Too many failures. Aborting.");
        }
    }

    public int read() throws IOException {
        while (true) {
            int ch;
            if ((ch = this.in.read()) >= 0) {
                ++this.read;
                return ch;
            }
            if (this.read >= this.totalLength) {
                return -1;
            }
            this.reconnect();
        }
    }

    public int read(byte[] b, int off, int len) throws IOException {
        while (true) {
            int r;
            if ((r = this.in.read(b, off, len)) >= 0) {
                this.read += r;
                return r;
            }
            if (this.read >= this.totalLength) {
                return -1;
            }
            this.reconnect();
        }
    }
}

