/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class PipeWindow {
    protected volatile Throwable dead;
    private static final Logger LOGGER = Logger.getLogger(PipeWindow.class.getName());

    PipeWindow() {
    }

    abstract int max();

    abstract void increase(int var1);

    abstract int peek();

    abstract int get(int var1) throws InterruptedException, IOException;

    abstract void decrease(int var1);

    void dead(Throwable cause) {
        this.dead = cause;
    }

    protected void checkDeath() throws IOException {
        if (this.dead != null) {
            throw (IOException)new IOException("Pipe is already closed").initCause(this.dead);
        }
    }

    static class Real
    extends PipeWindow {
        private final int initial;
        private int available;
        private long written;
        private long acked;
        private final int oid;
        private final Key key;

        Real(Key key, int initialSize) {
            this.key = key;
            this.oid = key.oid;
            this.available = initialSize;
            this.initial = initialSize;
        }

        @Override
        int max() {
            return this.initial;
        }

        @Override
        public synchronized void increase(int delta) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(String.format("increase(%d,%d)->%d", this.oid, delta, delta + this.available));
            }
            this.available += delta;
            this.acked += (long)delta;
            this.notifyAll();
        }

        @Override
        public synchronized int peek() {
            return this.available;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int get(int min) throws InterruptedException, IOException {
            this.checkDeath();
            Real real = this;
            synchronized (real) {
                if (this.available >= min) {
                    return this.available;
                }
                while (this.available < min) {
                    this.wait(100L);
                    this.checkDeath();
                }
                return this.available;
            }
        }

        @Override
        public synchronized void decrease(int delta) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(String.format("decrease(%d,%d)->%d", this.oid, delta, this.available - delta));
            }
            this.available -= delta;
            this.written += (long)delta;
        }
    }

    static final class Key {
        public final int oid;

        Key(int oid) {
            this.oid = oid;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.oid == ((Key)o).oid;
        }

        public int hashCode() {
            return this.oid;
        }
    }

    static class Fake
    extends PipeWindow {
        Fake() {
        }

        @Override
        int max() {
            return Integer.MAX_VALUE;
        }

        @Override
        void increase(int delta) {
        }

        @Override
        int peek() {
            return Integer.MAX_VALUE;
        }

        @Override
        int get(int min) throws InterruptedException, IOException {
            this.checkDeath();
            return Integer.MAX_VALUE;
        }

        @Override
        void decrease(int delta) {
        }
    }
}

