/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.lang;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.stapler.MetaClassLoader;
import org.kohsuke.stapler.lang.Klass;
import org.kohsuke.stapler.lang.MethodRef;

public abstract class KlassNavigator<C> {
    public static final KlassNavigator<Class> JAVA = new KlassNavigator<Class>(){

        @Override
        public URL getResource(Class clazz, String resourceName) {
            URL res;
            ClassLoader cl = clazz.getClassLoader();
            if (cl == null) {
                return null;
            }
            String fullName = resourceName.startsWith("/") ? resourceName.substring(1) : clazz.getName().replace('.', '/').replace('$', '/') + '/' + resourceName;
            if (MetaClassLoader.debugLoader != null && (res = MetaClassLoader.debugLoader.loader.getResource(fullName)) != null) {
                return res;
            }
            return cl.getResource(fullName);
        }

        @Override
        public Klass<?> getSuperClass(Class clazz) {
            return Klass.java(clazz.getSuperclass());
        }

        @Override
        public Iterable<Klass<?>> getAncestors(Class clazz) {
            ArrayList r = new ArrayList();
            while (clazz != null) {
                r.add(Klass.java(clazz));
                clazz = clazz.getSuperclass();
            }
            return r;
        }

        @Override
        public Class toJavaClass(Class clazz) {
            return clazz;
        }

        @Override
        public List<MethodRef> getDeclaredMethods(Class clazz) {
            final Method[] methods = clazz.getDeclaredMethods();
            return new AbstractList<MethodRef>(){

                @Override
                public MethodRef get(int index) {
                    return MethodRef.wrap(methods[index]);
                }

                @Override
                public int size() {
                    return methods.length;
                }
            };
        }
    };

    public abstract URL getResource(C var1, String var2);

    public abstract Iterable<Klass<?>> getAncestors(C var1);

    public abstract Klass<?> getSuperClass(C var1);

    public abstract Class toJavaClass(C var1);

    public abstract List<MethodRef> getDeclaredMethods(C var1);
}

