/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import java.lang.annotation.Annotation;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.ServletException;
import org.apache.commons.beanutils.Converter;
import org.kohsuke.stapler.InjectedParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public abstract class AnnotationHandler<T extends Annotation> {
    private static final ConcurrentMap<Class<? extends Annotation>, AnnotationHandler> HANDLERS = new ConcurrentHashMap<Class<? extends Annotation>, AnnotationHandler>();
    private static final AnnotationHandler NOT_HANDLER = new AnnotationHandler(){

        public Object parse(StaplerRequest request, Annotation a, Class type, String parameterName) throws ServletException {
            return null;
        }
    };

    public abstract Object parse(StaplerRequest var1, T var2, Class var3, String var4) throws ServletException;

    protected final Object convert(Class targetType, String value) {
        Converter converter = Stapler.lookupConverter(targetType);
        if (converter == null) {
            throw new IllegalArgumentException("Unable to convert to " + targetType);
        }
        return converter.convert(targetType, (Object)value);
    }

    static Object handle(StaplerRequest request, Annotation[] annotations, String parameterName, Class targetType) throws ServletException {
        for (Annotation a : annotations) {
            Class<? extends Annotation> at = a.annotationType();
            AnnotationHandler h = (AnnotationHandler)HANDLERS.get(at);
            if (h == null) {
                InjectedParameter ip = at.getAnnotation(InjectedParameter.class);
                if (ip != null) {
                    try {
                        h = ip.value().newInstance();
                    }
                    catch (InstantiationException e) {
                        throw new ServletException("Failed to instantiate parameter injector for " + at, (Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        throw new ServletException("Failed to instantiate parameter injector for " + at, (Throwable)e);
                    }
                } else {
                    h = NOT_HANDLER;
                }
                AnnotationHandler prev = HANDLERS.putIfAbsent(at, h);
                if (prev != null) {
                    h = prev;
                }
            }
            if (h == NOT_HANDLER) continue;
            return h.parse(request, a, targetType, parameterName);
        }
        return null;
    }
}

