/*
 * Decompiled with CFR 0.152.
 */
package jenkins.util;

import hudson.FilePath;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.util.DirScanner;
import hudson.util.FileVisitor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.MasterToSlaveFileCallable;

public abstract class VirtualFile
implements Comparable<VirtualFile>,
Serializable {
    @Nonnull
    public abstract String getName();

    public abstract URI toURI();

    public abstract VirtualFile getParent();

    public abstract boolean isDirectory() throws IOException;

    public abstract boolean isFile() throws IOException;

    public abstract boolean exists() throws IOException;

    @Nonnull
    public abstract VirtualFile[] list() throws IOException;

    @Nonnull
    public abstract String[] list(String var1) throws IOException;

    @Nonnull
    public abstract VirtualFile child(@Nonnull String var1);

    public abstract long length() throws IOException;

    public abstract long lastModified() throws IOException;

    public abstract boolean canRead() throws IOException;

    public abstract InputStream open() throws IOException;

    @Override
    public final int compareTo(VirtualFile o) {
        return this.getName().compareToIgnoreCase(o.getName());
    }

    public final boolean equals(Object obj) {
        return obj instanceof VirtualFile && this.toURI().equals(((VirtualFile)obj).toURI());
    }

    public final int hashCode() {
        return this.toURI().hashCode();
    }

    public final String toString() {
        return this.toURI().toString();
    }

    public <V> V run(Callable<V, IOException> callable) throws IOException {
        return callable.call();
    }

    public static VirtualFile forFile(File f) {
        return new FileVF(f, f);
    }

    public static VirtualFile forFilePath(FilePath f) {
        return new FilePathVF(f);
    }

    private static final class Readable
    extends MasterToSlaveFileCallable<Boolean> {
        private Readable() {
        }

        @Override
        public Boolean invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            return f.canRead();
        }
    }

    private static final class Scanner
    extends MasterToSlaveFileCallable<String[]> {
        private final String glob;

        Scanner(String glob) {
            this.glob = glob;
        }

        @Override
        public String[] invoke(File f, VirtualChannel channel) throws IOException {
            final ArrayList paths = new ArrayList();
            new DirScanner.Glob(this.glob, null).scan(f, new FileVisitor(){

                @Override
                public void visit(File f, String relativePath) throws IOException {
                    paths.add(relativePath);
                }
            });
            return paths.toArray(new String[paths.size()]);
        }
    }

    private static final class FilePathVF
    extends VirtualFile {
        private final FilePath f;

        FilePathVF(FilePath f) {
            this.f = f;
        }

        @Override
        public String getName() {
            return this.f.getName();
        }

        @Override
        public URI toURI() {
            try {
                return this.f.toURI();
            }
            catch (Exception x) {
                return URI.create(this.f.getRemote());
            }
        }

        @Override
        public VirtualFile getParent() {
            return this.f.getParent().toVirtualFile();
        }

        @Override
        public boolean isDirectory() throws IOException {
            try {
                return this.f.isDirectory();
            }
            catch (InterruptedException x) {
                throw (IOException)new IOException(x.toString()).initCause(x);
            }
        }

        @Override
        public boolean isFile() throws IOException {
            return this.exists() && !this.isDirectory();
        }

        @Override
        public boolean exists() throws IOException {
            try {
                return this.f.exists();
            }
            catch (InterruptedException x) {
                throw (IOException)new IOException(x.toString()).initCause(x);
            }
        }

        @Override
        public VirtualFile[] list() throws IOException {
            try {
                List<FilePath> kids = this.f.list();
                if (kids == null) {
                    return new VirtualFile[0];
                }
                VirtualFile[] vfs = new VirtualFile[kids.size()];
                for (int i = 0; i < vfs.length; ++i) {
                    vfs[i] = FilePathVF.forFilePath(kids.get(i));
                }
                return vfs;
            }
            catch (InterruptedException x) {
                throw (IOException)new IOException(x.toString()).initCause(x);
            }
        }

        @Override
        public String[] list(String glob) throws IOException {
            try {
                return this.f.act(new Scanner(glob));
            }
            catch (InterruptedException x) {
                throw (IOException)new IOException(x.toString()).initCause(x);
            }
        }

        @Override
        public VirtualFile child(String name) {
            return FilePathVF.forFilePath(this.f.child(name));
        }

        @Override
        public long length() throws IOException {
            try {
                return this.f.length();
            }
            catch (InterruptedException x) {
                throw (IOException)new IOException(x.toString()).initCause(x);
            }
        }

        @Override
        public long lastModified() throws IOException {
            try {
                return this.f.lastModified();
            }
            catch (InterruptedException x) {
                throw (IOException)new IOException(x.toString()).initCause(x);
            }
        }

        @Override
        public boolean canRead() throws IOException {
            try {
                return this.f.act(new Readable());
            }
            catch (InterruptedException x) {
                throw (IOException)new IOException(x.toString()).initCause(x);
            }
        }

        @Override
        public InputStream open() throws IOException {
            try {
                return this.f.read();
            }
            catch (InterruptedException x) {
                throw (IOException)new IOException(x.toString()).initCause(x);
            }
        }

        @Override
        public <V> V run(Callable<V, IOException> callable) throws IOException {
            try {
                return this.f.act(callable);
            }
            catch (InterruptedException x) {
                throw (IOException)new IOException(x.toString()).initCause(x);
            }
        }
    }

    private static final class FileVF
    extends VirtualFile {
        private final File f;
        private final File root;

        FileVF(File f, File root) {
            this.f = f;
            this.root = root;
        }

        @Override
        public String getName() {
            return this.f.getName();
        }

        @Override
        public URI toURI() {
            return this.f.toURI();
        }

        @Override
        public VirtualFile getParent() {
            return new FileVF(this.f.getParentFile(), this.root);
        }

        @Override
        public boolean isDirectory() throws IOException {
            if (this.isIllegalSymlink()) {
                return false;
            }
            return this.f.isDirectory();
        }

        @Override
        public boolean isFile() throws IOException {
            if (this.isIllegalSymlink()) {
                return false;
            }
            return this.f.isFile();
        }

        @Override
        public boolean exists() throws IOException {
            if (this.isIllegalSymlink()) {
                return false;
            }
            return this.f.exists();
        }

        @Override
        public VirtualFile[] list() throws IOException {
            if (this.isIllegalSymlink()) {
                return new VirtualFile[0];
            }
            File[] kids = this.f.listFiles();
            if (kids == null) {
                return new VirtualFile[0];
            }
            VirtualFile[] vfs = new VirtualFile[kids.length];
            for (int i = 0; i < kids.length; ++i) {
                vfs[i] = new FileVF(kids[i], this.root);
            }
            return vfs;
        }

        @Override
        public String[] list(String glob) throws IOException {
            if (this.isIllegalSymlink()) {
                return new String[0];
            }
            return new Scanner(glob).invoke(this.f, null);
        }

        @Override
        public VirtualFile child(String name) {
            return new FileVF(new File(this.f, name), this.root);
        }

        @Override
        public long length() throws IOException {
            if (this.isIllegalSymlink()) {
                return 0L;
            }
            return this.f.length();
        }

        @Override
        public long lastModified() throws IOException {
            if (this.isIllegalSymlink()) {
                return 0L;
            }
            return this.f.lastModified();
        }

        @Override
        public boolean canRead() throws IOException {
            if (this.isIllegalSymlink()) {
                return false;
            }
            return this.f.canRead();
        }

        @Override
        public InputStream open() throws IOException {
            if (this.isIllegalSymlink()) {
                throw new FileNotFoundException(this.f.getPath());
            }
            return new FileInputStream(this.f);
        }

        private boolean isIllegalSymlink() {
            try {
                String myPath = this.f.toPath().toRealPath(new LinkOption[0]).toString();
                String rootPath = this.root.toPath().toRealPath(new LinkOption[0]).toString();
                if (!myPath.equals(rootPath) && !myPath.startsWith(rootPath + File.separatorChar)) {
                    return true;
                }
            }
            catch (IOException x) {
                Logger.getLogger(VirtualFile.class.getName()).log(Level.FINE, "could not determine symlink status of " + this.f, x);
            }
            catch (InvalidPathException x2) {
                Logger.getLogger(VirtualFile.class.getName()).log(Level.FINE, "Could not convert " + this.f + " to path", x2);
            }
            return false;
        }
    }
}

