/*
 * Decompiled with CFR 0.152.
 */
package jenkins.util;

import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.sf.json.JSONObject;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class ResourceBundleUtil {
    private static final Map<String, JSONObject> bundles = new ConcurrentHashMap<String, JSONObject>();

    private ResourceBundleUtil() {
    }

    @Nonnull
    public static JSONObject getBundle(@Nonnull String baseName) throws MissingResourceException {
        return ResourceBundleUtil.getBundle(baseName, Locale.getDefault());
    }

    @Nonnull
    public static JSONObject getBundle(@Nonnull String baseName, @Nonnull Locale locale) throws MissingResourceException {
        String bundleKey = baseName + ":" + locale.toString();
        JSONObject bundleJSON = bundles.get(bundleKey);
        if (bundleJSON != null) {
            return bundleJSON;
        }
        ResourceBundle bundle = ResourceBundle.getBundle(baseName, locale);
        bundleJSON = ResourceBundleUtil.toJSONObject(bundle);
        bundles.put(bundleKey, bundleJSON);
        return bundleJSON;
    }

    private static JSONObject toJSONObject(@Nonnull ResourceBundle bundle) {
        JSONObject json = new JSONObject();
        for (String key : bundle.keySet()) {
            json.put(key, (Object)bundle.getString(key));
        }
        return json;
    }
}

