/*
 * Decompiled with CFR 0.152.
 */
package jenkins.triggers;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.Util;
import hudson.console.ModelHyperlinkNote;
import hudson.model.AbstractBuild;
import hudson.model.AbstractItem;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.AutoCompletionCandidates;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.DependencyGraph;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Items;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.ItemListener;
import hudson.model.listeners.RunListener;
import hudson.model.queue.Tasks;
import hudson.security.ACL;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.DependencyDeclarer;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import jenkins.security.QueueItemAuthenticatorConfiguration;
import jenkins.triggers.Messages;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public final class ReverseBuildTrigger
extends Trigger<Job>
implements DependencyDeclarer {
    private static final Logger LOGGER = Logger.getLogger(ReverseBuildTrigger.class.getName());
    private String upstreamProjects;
    private final Result threshold;

    @DataBoundConstructor
    public ReverseBuildTrigger(String upstreamProjects, Result threshold) {
        this.upstreamProjects = upstreamProjects;
        this.threshold = threshold;
    }

    public String getUpstreamProjects() {
        return this.upstreamProjects;
    }

    public Result getThreshold() {
        return this.threshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldTrigger(Run upstreamBuild, TaskListener listener) {
        Jenkins jenkins = Jenkins.getInstance();
        if (this.job == null) {
            return false;
        }
        boolean downstreamVisible = jenkins.getItemByFullName(((Job)this.job).getFullName()) == this.job;
        Authentication originalAuth = Jenkins.getAuthentication();
        Object upstream = upstreamBuild.getParent();
        Authentication auth = Tasks.getAuthenticationOf((Queue.Task)((Object)this.job));
        if (auth.equals(ACL.SYSTEM) && !QueueItemAuthenticatorConfiguration.get().getAuthenticators().isEmpty()) {
            auth = Jenkins.ANONYMOUS;
        }
        SecurityContext orig = ACL.impersonate(auth);
        try {
            if (jenkins.getItemByFullName(((AbstractItem)upstream).getFullName()) != upstream) {
                if (downstreamVisible) {
                    listener.getLogger().println(Messages.ReverseBuildTrigger_running_as_cannot_even_see_for_trigger_f(auth.getName(), ((AbstractItem)upstream).getFullName(), ((Job)this.job).getFullName()));
                } else {
                    LOGGER.log(Level.WARNING, "Running as {0} cannot even see {1} for trigger from {2} (but cannot tell {3} that)", new Object[]{auth.getName(), upstream, this.job, originalAuth.getName()});
                }
                boolean bl = false;
                return bl;
            }
        }
        finally {
            SecurityContextHolder.setContext((SecurityContext)orig);
        }
        Result result = upstreamBuild.getResult();
        return result != null && result.isBetterOrEqualTo(this.threshold);
    }

    @Override
    public void buildDependencyGraph(AbstractProject downstream, DependencyGraph graph) {
        for (AbstractProject upstream : Items.fromNameList(downstream.getParent(), this.upstreamProjects, AbstractProject.class)) {
            graph.addDependency(new DependencyGraph.Dependency(upstream, downstream){

                @Override
                public boolean shouldTriggerBuild(AbstractBuild upstreamBuild, TaskListener listener, List<Action> actions) {
                    return ReverseBuildTrigger.this.shouldTrigger(upstreamBuild, listener);
                }
            });
        }
    }

    @Override
    public void start(@Nonnull Job project, boolean newInstance) {
        super.start(project, newInstance);
        RunListenerImpl.get().invalidateCache();
    }

    @Override
    public void stop() {
        super.stop();
        RunListenerImpl.get().invalidateCache();
    }

    @Extension
    public static class ItemListenerImpl
    extends ItemListener {
        @Override
        public void onLocationChanged(Item item, final String oldFullName, final String newFullName) {
            ACL.impersonate(ACL.SYSTEM, new Runnable(){

                @Override
                public void run() {
                    for (Job p : Jenkins.getInstance().getAllItems(Job.class)) {
                        String revised;
                        ReverseBuildTrigger t = ParameterizedJobMixIn.getTrigger(p, ReverseBuildTrigger.class);
                        if (t == null || (revised = Items.computeRelativeNamesAfterRenaming(oldFullName, newFullName, t.upstreamProjects, p.getParent())).equals(t.upstreamProjects)) continue;
                        t.upstreamProjects = revised;
                        try {
                            p.save();
                        }
                        catch (IOException e) {
                            LOGGER.log(Level.WARNING, "Failed to persist project setting during rename from " + oldFullName + " to " + newFullName, e);
                        }
                    }
                }
            });
        }
    }

    @Extension
    public static final class RunListenerImpl
    extends RunListener<Run> {
        private Map<Job, Collection<ReverseBuildTrigger>> upstream2Trigger;

        static RunListenerImpl get() {
            return ExtensionList.lookup(RunListener.class).get(RunListenerImpl.class);
        }

        synchronized void invalidateCache() {
            this.upstream2Trigger = null;
        }

        private Map<Job, Collection<ReverseBuildTrigger>> calculateCache() {
            final WeakHashMap<Job, Collection<ReverseBuildTrigger>> result = new WeakHashMap<Job, Collection<ReverseBuildTrigger>>();
            ACL.impersonate(ACL.SYSTEM, new Runnable(){

                @Override
                public void run() {
                    for (Job downstream : Jenkins.getInstance().getAllItems(Job.class)) {
                        ReverseBuildTrigger trigger = ParameterizedJobMixIn.getTrigger(downstream, ReverseBuildTrigger.class);
                        if (trigger == null) continue;
                        List<Job> upstreams = Items.fromNameList(downstream.getParent(), trigger.upstreamProjects, Job.class);
                        LOGGER.log(Level.FINE, "from {0} see upstreams {1}", new Object[]{downstream, upstreams});
                        for (Job upstream : upstreams) {
                            if (upstream instanceof AbstractProject && downstream instanceof AbstractProject) continue;
                            LinkedList<ReverseBuildTrigger> triggers = (LinkedList<ReverseBuildTrigger>)result.get(upstream);
                            if (triggers == null) {
                                triggers = new LinkedList<ReverseBuildTrigger>();
                                result.put(upstream, triggers);
                            }
                            triggers.remove(trigger);
                            triggers.add(trigger);
                        }
                    }
                }
            });
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCompleted(@Nonnull Run r, @Nonnull TaskListener listener) {
            ArrayList<ReverseBuildTrigger> triggers;
            RunListenerImpl runListenerImpl = this;
            synchronized (runListenerImpl) {
                Collection<ReverseBuildTrigger> _triggers;
                if (this.upstream2Trigger == null) {
                    this.upstream2Trigger = this.calculateCache();
                }
                if ((_triggers = this.upstream2Trigger.get(r.getParent())) == null || _triggers.isEmpty()) {
                    return;
                }
                triggers = new ArrayList<ReverseBuildTrigger>(_triggers);
            }
            for (ReverseBuildTrigger trigger : triggers) {
                if (!trigger.shouldTrigger(r, listener)) continue;
                if (!((Job)trigger.job).isBuildable()) {
                    listener.getLogger().println(hudson.tasks.Messages.BuildTrigger_Disabled(ModelHyperlinkNote.encodeTo(trigger.job)));
                    continue;
                }
                String name = ModelHyperlinkNote.encodeTo(trigger.job) + " #" + ((Job)trigger.job).getNextBuildNumber();
                if (ParameterizedJobMixIn.scheduleBuild2((Job)trigger.job, -1, new CauseAction((Cause)new Cause.UpstreamCause(r))) != null) {
                    listener.getLogger().println(hudson.tasks.Messages.BuildTrigger_Triggering(name));
                    continue;
                }
                listener.getLogger().println(hudson.tasks.Messages.BuildTrigger_InQueue(name));
            }
        }
    }

    @Extension
    @Symbol(value={"upstream"})
    public static final class DescriptorImpl
    extends TriggerDescriptor {
        @Override
        public String getDisplayName() {
            return Messages.ReverseBuildTrigger_build_after_other_projects_are_built();
        }

        @Override
        public boolean isApplicable(Item item) {
            return item instanceof Job && item instanceof ParameterizedJobMixIn.ParameterizedJob;
        }

        public AutoCompletionCandidates doAutoCompleteUpstreamProjects(@QueryParameter String value, @AncestorInPath Item self, @AncestorInPath ItemGroup container) {
            return AutoCompletionCandidates.ofJobNames(Job.class, value, self, container);
        }

        public FormValidation doCheckUpstreamProjects(@AncestorInPath Job project, @QueryParameter String value) {
            if (!project.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            StringTokenizer tokens = new StringTokenizer(Util.fixNull(value), ",");
            boolean hasProjects = false;
            while (tokens.hasMoreTokens()) {
                String projectName = tokens.nextToken().trim();
                if (!StringUtils.isNotBlank((String)projectName)) continue;
                Job item = Jenkins.getInstance().getItem(projectName, project, Job.class);
                if (item == null) {
                    Job nearest = Items.findNearest(Job.class, projectName, project.getParent());
                    String alternative = nearest != null ? nearest.getRelativeNameFrom(project) : "?";
                    return FormValidation.error(hudson.tasks.Messages.BuildTrigger_NoSuchProject(projectName, alternative));
                }
                hasProjects = true;
            }
            if (!hasProjects) {
                return FormValidation.error(hudson.tasks.Messages.BuildTrigger_NoProjectSpecified());
            }
            return FormValidation.ok();
        }
    }
}

