/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.codec.binary.Base64;

public class UnbufferedBase64InputStream
extends FilterInputStream {
    private byte[] encoded = new byte[4];
    private byte[] decoded;
    private int pos;
    private final DataInputStream din;

    public UnbufferedBase64InputStream(InputStream in) {
        super(in);
        this.din = new DataInputStream(in);
        this.pos = 4;
        this.decoded = this.encoded;
    }

    @Override
    public int read() throws IOException {
        if (this.decoded.length == 0) {
            return -1;
        }
        if (this.pos == this.decoded.length) {
            this.din.readFully(this.encoded);
            this.decoded = Base64.decodeBase64((byte[])this.encoded);
            if (this.decoded.length == 0) {
                return -1;
            }
            this.pos = 0;
        }
        return this.decoded[this.pos++] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int ch;
        int i;
        for (i = 0; i < len && (ch = this.read()) >= 0; ++i) {
            b[off + i] = (byte)ch;
        }
        return i == 0 ? -1 : i;
    }

    @Override
    public long skip(long n) throws IOException {
        int ch;
        long r = 0L;
        while (n > 0L && (ch = this.read()) >= 0) {
            --n;
            ++r;
        }
        return r;
    }
}

