/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import com.google.common.collect.AbstractIterator;
import hudson.util.AtomicFileWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;

public class TextFile {
    public final File file;

    public TextFile(File file) {
        this.file = file;
    }

    public boolean exists() {
        return this.file.exists();
    }

    public void delete() {
        this.file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String read() throws IOException {
        StringWriter out = new StringWriter();
        PrintWriter w = new PrintWriter(out);
        try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), "UTF-8"));){
            String line;
            while ((line = in.readLine()) != null) {
                w.println(line);
            }
        }
        return out.toString();
    }

    public Iterable<String> lines() {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                try {
                    final BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(TextFile.this.file), "UTF-8"));
                    return new AbstractIterator<String>(){

                        protected String computeNext() {
                            try {
                                String r = in.readLine();
                                if (r == null) {
                                    in.close();
                                    return (String)this.endOfData();
                                }
                                return r;
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    };
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String text) throws IOException {
        this.file.getParentFile().mkdirs();
        AtomicFileWriter w = new AtomicFileWriter(this.file);
        try {
            w.write(text);
            w.commit();
        }
        finally {
            w.abort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public String head(int numChars) throws IOException {
        char[] buf = new char[numChars];
        FileReader r = new FileReader(this.file);
        try {
            int read;
            int d;
            for (read = 0; read < numChars && (d = ((Reader)r).read(buf, read, buf.length - read)) >= 0; read += d) {
            }
            String string = new String(buf, 0, read);
            return string;
        }
        finally {
            IOUtils.closeQuietly((Reader)r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public String fastTail(int numChars, Charset cs) throws IOException {
        try (RandomAccessFile raf = new RandomAccessFile(this.file, "r");){
            long len = raf.length();
            long pos = Math.max(0L, len - (long)(numChars * 4 + 1024));
            raf.seek(pos);
            byte[] tail = new byte[(int)(len - pos)];
            raf.readFully(tail);
            String tails = cs.decode(ByteBuffer.wrap(tail)).toString();
            String string = new String(tails.substring(Math.max(0, tails.length() - numChars)));
            return string;
        }
    }

    @Nonnull
    public String fastTail(int numChars) throws IOException {
        return this.fastTail(numChars, Charset.defaultCharset());
    }

    public String readTrim() throws IOException {
        return this.read().trim();
    }

    public String toString() {
        return this.file.toString();
    }
}

