/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import hudson.FilePath;
import hudson.Functions;
import hudson.remoting.AsyncFutureImpl;
import hudson.remoting.DelegatingCallable;
import hudson.remoting.Future;
import hudson.remoting.VirtualChannel;
import hudson.security.AccessControlled;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.http.HttpServletRequest;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.WebMethod;

public final class RemotingDiagnostics {
    public static Map<Object, Object> getSystemProperties(VirtualChannel channel) throws IOException, InterruptedException {
        if (channel == null) {
            return Collections.singletonMap("N/A", "N/A");
        }
        return channel.call(new GetSystemProperties());
    }

    public static Map<String, String> getThreadDump(VirtualChannel channel) throws IOException, InterruptedException {
        if (channel == null) {
            return Collections.singletonMap("N/A", "N/A");
        }
        return channel.call(new GetThreadDump());
    }

    public static Future<Map<String, String>> getThreadDumpAsync(VirtualChannel channel) throws IOException, InterruptedException {
        if (channel == null) {
            return new AsyncFutureImpl<Map<String, String>>(Collections.singletonMap("N/A", "offline"));
        }
        return channel.callAsync(new GetThreadDump());
    }

    public static String executeGroovy(String script, @Nonnull VirtualChannel channel) throws IOException, InterruptedException {
        return channel.call(new Script(script));
    }

    public static FilePath getHeapDump(VirtualChannel channel) throws IOException, InterruptedException {
        return channel.call(new MasterToSlaveCallable<FilePath, IOException>(){
            private static final long serialVersionUID = 1L;

            @Override
            public FilePath call() throws IOException {
                File hprof = File.createTempFile("hudson-heapdump", "hprof");
                hprof.delete();
                try {
                    MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                    server.invoke(new ObjectName("com.sun.management:type=HotSpotDiagnostic"), "dumpHeap", new Object[]{hprof.getAbsolutePath(), true}, new String[]{String.class.getName(), Boolean.TYPE.getName()});
                    return new FilePath(hprof);
                }
                catch (JMException e) {
                    throw new IOException(e);
                }
            }
        });
    }

    public static class HeapDump {
        private final AccessControlled owner;
        private final VirtualChannel channel;

        public HeapDump(AccessControlled owner, VirtualChannel channel) {
            this.owner = owner;
            this.channel = channel;
        }

        public void doIndex(StaplerResponse rsp) throws IOException {
            rsp.sendRedirect("heapdump.hprof");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WebMethod(name={"heapdump.hprof"})
        public void doHeapDump(StaplerRequest req, StaplerResponse rsp) throws IOException, InterruptedException {
            this.owner.checkPermission(Jenkins.RUN_SCRIPTS);
            rsp.setContentType("application/octet-stream");
            FilePath dump = this.obtain();
            try {
                dump.copyTo(rsp.getCompressedOutputStream((HttpServletRequest)req));
            }
            finally {
                dump.delete();
            }
        }

        public FilePath obtain() throws IOException, InterruptedException {
            return RemotingDiagnostics.getHeapDump(this.channel);
        }
    }

    private static final class Script
    extends MasterToSlaveCallable<String, RuntimeException>
    implements DelegatingCallable<String, RuntimeException> {
        private final String script;
        private transient ClassLoader cl;

        private Script(String script) {
            this.script = script;
            this.cl = this.getClassLoader();
        }

        @Override
        public ClassLoader getClassLoader() {
            return Jenkins.getInstance().getPluginManager().uberClassLoader;
        }

        @Override
        public String call() throws RuntimeException {
            if (this.cl == null) {
                this.cl = Thread.currentThread().getContextClassLoader();
            }
            CompilerConfiguration cc = new CompilerConfiguration();
            cc.addCompilationCustomizers(new CompilationCustomizer[]{new ImportCustomizer().addStarImports(new String[]{"jenkins", "jenkins.model", "hudson", "hudson.model"})});
            GroovyShell shell = new GroovyShell(this.cl, new Binding(), cc);
            StringWriter out = new StringWriter();
            PrintWriter pw = new PrintWriter(out);
            shell.setVariable("out", (Object)pw);
            try {
                Object output = shell.evaluate(this.script);
                if (output != null) {
                    pw.println("Result: " + output);
                }
            }
            catch (Throwable t) {
                t.printStackTrace(pw);
            }
            return out.toString();
        }
    }

    private static final class GetThreadDump
    extends MasterToSlaveCallable<Map<String, String>, RuntimeException> {
        private static final long serialVersionUID = 1L;

        private GetThreadDump() {
        }

        @Override
        public Map<String, String> call() {
            LinkedHashMap<String, String> r = new LinkedHashMap<String, String>();
            ThreadInfo[] data = Functions.getThreadInfos();
            Functions.ThreadGroupMap map = Functions.sortThreadsAndGetGroupMap(data);
            for (ThreadInfo ti : data) {
                r.put(ti.getThreadName(), Functions.dumpThreadInfo(ti, map));
            }
            return r;
        }
    }

    private static final class GetSystemProperties
    extends MasterToSlaveCallable<Map<Object, Object>, RuntimeException> {
        private static final long serialVersionUID = 1L;

        private GetSystemProperties() {
        }

        @Override
        public Map<Object, Object> call() {
            return new TreeMap<Object, Object>(System.getProperties());
        }
    }
}

