/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import com.trilead.ssh2.crypto.Base64;
import hudson.util.Secret;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

public class Protector {
    private static final String ALGORITHM = "DES";
    private static final String MAGIC = ":::";
    private static final SecretKey DES_KEY;

    public static String protect(String secret) {
        try {
            Cipher cipher = Secret.getCipher(ALGORITHM);
            cipher.init(1, DES_KEY);
            return new String(Base64.encode((byte[])cipher.doFinal((secret + MAGIC).getBytes("UTF-8"))));
        }
        catch (GeneralSecurityException e) {
            throw new Error(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }

    public static String unprotect(String data) {
        if (data == null) {
            return null;
        }
        try {
            Cipher cipher = Secret.getCipher(ALGORITHM);
            cipher.init(2, DES_KEY);
            String plainText = new String(cipher.doFinal(Base64.decode((char[])data.toCharArray())), "UTF-8");
            if (plainText.endsWith(MAGIC)) {
                return plainText.substring(0, plainText.length() - 3);
            }
            return null;
        }
        catch (GeneralSecurityException e) {
            return null;
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
        catch (IOException e) {
            return null;
        }
    }

    static {
        try {
            DES_KEY = KeyGenerator.getInstance(ALGORITHM).generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error(e);
        }
    }
}

