/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import hudson.Util;
import hudson.util.FileVisitor;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Serializable;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;

public abstract class DirScanner
implements Serializable {
    private static final long serialVersionUID = 1L;

    public abstract void scan(File var1, FileVisitor var2) throws IOException;

    protected final void scanSingle(File f, String relative, FileVisitor visitor) throws IOException {
        if (visitor.understandsSymlink()) {
            try {
                String target;
                try {
                    target = Util.resolveSymlink(f);
                }
                catch (IOException x) {
                    target = null;
                }
                if (target != null) {
                    visitor.visitSymlink(f, target, relative);
                    return;
                }
            }
            catch (InterruptedException e) {
                throw (IOException)new InterruptedIOException().initCause(e);
            }
        }
        visitor.visit(f, relative);
    }

    public static class Glob
    extends DirScanner {
        private final String includes;
        private final String excludes;
        private boolean useDefaultExcludes = true;
        private static final long serialVersionUID = 1L;

        public Glob(String includes, String excludes) {
            this.includes = includes;
            this.excludes = excludes;
        }

        public Glob(String includes, String excludes, boolean useDefaultExcludes) {
            this(includes, excludes);
            this.useDefaultExcludes = useDefaultExcludes;
        }

        @Override
        public void scan(File dir, FileVisitor visitor) throws IOException {
            if (Util.fixEmpty(this.includes) == null && this.excludes == null) {
                new Full().scan(dir, visitor);
                return;
            }
            FileSet fs = Util.createFileSet(dir, this.includes, this.excludes);
            fs.setDefaultexcludes(this.useDefaultExcludes);
            if (dir.exists()) {
                DirectoryScanner ds = fs.getDirectoryScanner(new Project());
                for (String f : ds.getIncludedFiles()) {
                    File file = new File(dir, f);
                    this.scanSingle(file, f, visitor);
                }
            }
        }
    }

    public static class Filter
    extends Full {
        private final FileFilter filter;
        private static final long serialVersionUID = 1L;

        public Filter(FileFilter filter) {
            this.filter = filter;
        }

        @Override
        public void scan(File dir, FileVisitor visitor) throws IOException {
            super.scan(dir, visitor.with(this.filter));
        }
    }

    public static class Full
    extends DirScanner {
        private static final long serialVersionUID = 1L;

        private void scan(File f, String path, FileVisitor visitor) throws IOException {
            if (f.canRead()) {
                this.scanSingle(f, path + f.getName(), visitor);
                if (f.isDirectory()) {
                    for (File child : f.listFiles()) {
                        this.scan(child, path + f.getName() + '/', visitor);
                    }
                }
            }
        }

        @Override
        public void scan(File dir, FileVisitor visitor) throws IOException {
            this.scan(dir, "", visitor);
        }
    }
}

