/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Functions;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.EnvironmentSpecific;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.slaves.NodeSpecific;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.tasks.Messages;
import hudson.tasks._maven.MavenConsoleAnnotator;
import hudson.tools.DownloadFromUrlInstaller;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolInstaller;
import hudson.tools.ToolProperty;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormValidation;
import hudson.util.NullStream;
import hudson.util.StreamTaskListener;
import hudson.util.VariableResolver;
import hudson.util.XStream2;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import jenkins.MasterToSlaveFileCallable;
import jenkins.model.Jenkins;
import jenkins.mvn.GlobalMavenConfig;
import jenkins.mvn.GlobalSettingsProvider;
import jenkins.mvn.SettingsProvider;
import jenkins.security.MasterToSlaveCallable;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class Maven
extends Builder {
    public final String targets;
    public final String mavenName;
    public final String jvmOptions;
    public final String pom;
    public final String properties;
    public boolean usePrivateRepository = false;
    private SettingsProvider settings;
    private GlobalSettingsProvider globalSettings;
    private static final String MAVEN_1_INSTALLATION_COMMON_FILE = "bin/maven";
    private static final String MAVEN_2_INSTALLATION_COMMON_FILE = "bin/mvn";
    private static final Pattern S_PATTERN = Pattern.compile("(^| )-s ");
    private static final Pattern GS_PATTERN = Pattern.compile("(^| )-gs ");
    @Deprecated
    public static DescriptorImpl DESCRIPTOR;

    public Maven(String targets, String name) {
        this(targets, name, null, null, null, false, null, null);
    }

    public Maven(String targets, String name, String pom, String properties, String jvmOptions) {
        this(targets, name, pom, properties, jvmOptions, false, null, null);
    }

    public Maven(String targets, String name, String pom, String properties, String jvmOptions, boolean usePrivateRepository) {
        this(targets, name, pom, properties, jvmOptions, usePrivateRepository, null, null);
    }

    @DataBoundConstructor
    public Maven(String targets, String name, String pom, String properties, String jvmOptions, boolean usePrivateRepository, SettingsProvider settings, GlobalSettingsProvider globalSettings) {
        this.targets = targets;
        this.mavenName = name;
        this.pom = Util.fixEmptyAndTrim(pom);
        this.properties = Util.fixEmptyAndTrim(properties);
        this.jvmOptions = Util.fixEmptyAndTrim(jvmOptions);
        this.usePrivateRepository = usePrivateRepository;
        this.settings = settings != null ? settings : GlobalMavenConfig.get().getSettingsProvider();
        this.globalSettings = globalSettings != null ? globalSettings : GlobalMavenConfig.get().getGlobalSettingsProvider();
    }

    public String getTargets() {
        return this.targets;
    }

    public SettingsProvider getSettings() {
        return this.settings != null ? this.settings : GlobalMavenConfig.get().getSettingsProvider();
    }

    protected void setSettings(SettingsProvider settings) {
        this.settings = settings;
    }

    public GlobalSettingsProvider getGlobalSettings() {
        return this.globalSettings != null ? this.globalSettings : GlobalMavenConfig.get().getGlobalSettingsProvider();
    }

    protected void setGlobalSettings(GlobalSettingsProvider globalSettings) {
        this.globalSettings = globalSettings;
    }

    public void setUsePrivateRepository(boolean usePrivateRepository) {
        this.usePrivateRepository = usePrivateRepository;
    }

    public boolean usesPrivateRepository() {
        return this.usePrivateRepository;
    }

    public MavenInstallation getMaven() {
        for (MavenInstallation i : this.getDescriptor().getInstallations()) {
            if (this.mavenName == null || !this.mavenName.equals(i.getName())) continue;
            return i;
        }
        return null;
    }

    @Override
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        int endIndex;
        VariableResolver<String> vr = build.getBuildVariableResolver();
        EnvVars env = build.getEnvironment(listener);
        String targets = Util.replaceMacro(this.targets, vr);
        targets = env.expand(targets);
        String pom = env.expand(this.pom);
        int startIndex = 0;
        do {
            String settingsPath;
            if (-1 == (endIndex = targets.indexOf(124, startIndex))) {
                endIndex = targets.length();
            }
            String normalizedTarget = targets.substring(startIndex, endIndex).replaceAll("[\t\r\n]+", " ");
            ArgumentListBuilder args = new ArgumentListBuilder();
            MavenInstallation mi = this.getMaven();
            if (mi == null) {
                String execName = build.getWorkspace().act(new DecideDefaultMavenCommand(normalizedTarget));
                args.add(execName);
            } else {
                mi = mi.forNode(Computer.currentComputer().getNode(), listener);
                String exec = (mi = mi.forEnvironment(env)).getExecutable(launcher);
                if (exec == null) {
                    listener.fatalError(Messages.Maven_NoExecutable(mi.getHome()));
                    return false;
                }
                args.add(exec);
            }
            if (pom != null) {
                args.add("-f", pom);
            }
            if (!S_PATTERN.matcher(targets).find() && StringUtils.isNotBlank((String)(settingsPath = SettingsProvider.getSettingsRemotePath(this.getSettings(), build, listener)))) {
                args.add("-s", settingsPath);
            }
            if (!GS_PATTERN.matcher(targets).find() && StringUtils.isNotBlank((String)(settingsPath = GlobalSettingsProvider.getSettingsRemotePath(this.getGlobalSettings(), build, listener)))) {
                args.add("-gs", settingsPath);
            }
            Set<String> sensitiveVars = build.getSensitiveBuildVariables();
            args.addKeyValuePairs("-D", build.getBuildVariables(), sensitiveVars);
            VariableResolver.Union<String> resolver = new VariableResolver.Union<String>(new VariableResolver.ByMap<String>(env), vr);
            args.addKeyValuePairsFromPropertyString("-D", this.properties, resolver, sensitiveVars);
            if (this.usesPrivateRepository()) {
                args.add("-Dmaven.repo.local=" + build.getWorkspace().child(".repository"));
            }
            args.addTokenized(normalizedTarget);
            this.wrapUpArguments(args, normalizedTarget, build, launcher, listener);
            this.buildEnvVars(env, mi);
            if (!launcher.isUnix()) {
                args = args.toWindowsCommand();
            }
            try {
                MavenConsoleAnnotator mca = new MavenConsoleAnnotator(listener.getLogger(), build.getCharset());
                int r = launcher.launch().cmds(args).envs(env).stdout(mca).pwd(build.getModuleRoot()).join();
                if (0 != r) {
                    return false;
                }
            }
            catch (IOException e) {
                Util.displayIOException(e, listener);
                e.printStackTrace(listener.fatalError(Messages.Maven_ExecFailed()));
                return false;
            }
        } while ((startIndex = endIndex + 1) < targets.length());
        return true;
    }

    protected void wrapUpArguments(ArgumentListBuilder args, String normalizedTarget, AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
    }

    protected void buildEnvVars(EnvVars env, MavenInstallation mi) throws IOException, InterruptedException {
        if (mi != null) {
            mi.buildEnvVars(env);
        }
        env.put("MAVEN_TERMINATE_CMD", "on");
        String jvmOptions = env.expand(this.jvmOptions);
        if (jvmOptions != null) {
            env.put("MAVEN_OPTS", jvmOptions.replaceAll("[\t\r\n]+", " "));
        }
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public static interface ProjectWithMaven {
        public MavenInstallation inferMavenInstallation();
    }

    public static class MavenInstaller
    extends DownloadFromUrlInstaller {
        @DataBoundConstructor
        public MavenInstaller(String id) {
            super(id);
        }

        @Extension
        @Symbol(value={"maven"})
        public static final class DescriptorImpl
        extends DownloadFromUrlInstaller.DescriptorImpl<MavenInstaller> {
            @Override
            public String getDisplayName() {
                return Messages.InstallFromApache();
            }

            @Override
            public boolean isApplicable(Class<? extends ToolInstallation> toolType) {
                return toolType == MavenInstallation.class;
            }
        }
    }

    public static final class MavenInstallation
    extends ToolInstallation
    implements EnvironmentSpecific<MavenInstallation>,
    NodeSpecific<MavenInstallation> {
        public static final int MAVEN_20 = 0;
        public static final int MAVEN_21 = 1;
        public static final int MAVEN_30 = 2;
        @Deprecated
        private transient String mavenHome;
        private static final long serialVersionUID = 1L;

        @Deprecated
        public MavenInstallation(String name, String home) {
            super(name, home);
        }

        @DataBoundConstructor
        public MavenInstallation(String name, String home, List<? extends ToolProperty<?>> properties) {
            super(Util.fixEmptyAndTrim(name), Util.fixEmptyAndTrim(home), properties);
        }

        @Deprecated
        public String getMavenHome() {
            return this.getHome();
        }

        public File getHomeDir() {
            return new File(this.getHome());
        }

        @Override
        public void buildEnvVars(EnvVars env) {
            String home = this.getHome();
            if (home == null) {
                return;
            }
            env.put("M2_HOME", home);
            env.put("MAVEN_HOME", home);
            env.put("PATH+MAVEN", home + "/bin");
        }

        public boolean meetsMavenReqVersion(Launcher launcher, int mavenReqVersion) throws IOException, InterruptedException {
            String mavenVersion = launcher.getChannel().call(new MasterToSlaveCallable<String, IOException>(){
                private static final long serialVersionUID = -4143159957567745621L;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public String call() throws IOException {
                    File[] jars = new File(MavenInstallation.this.getHomeDir(), "lib").listFiles();
                    if (jars != null) {
                        for (File jar : jars) {
                            if (!jar.getName().startsWith("maven-")) continue;
                            try (JarFile jf = null;){
                                jf = new JarFile(jar);
                                Manifest manifest = jf.getManifest();
                                String version = manifest.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                                if (version == null) continue;
                                String string = version;
                                return string;
                            }
                        }
                    }
                    return "";
                }
            });
            return !mavenVersion.equals("") && (mavenReqVersion == 0 ? mavenVersion.startsWith("2.") : (mavenReqVersion == 1 ? mavenVersion.startsWith("2.") && !mavenVersion.startsWith("2.0") : mavenReqVersion == 2 && mavenVersion.startsWith("3.")));
        }

        public boolean isMaven2_1(Launcher launcher) throws IOException, InterruptedException {
            return this.meetsMavenReqVersion(launcher, 1);
        }

        public String getExecutable(Launcher launcher) throws IOException, InterruptedException {
            return launcher.getChannel().call(new MasterToSlaveCallable<String, IOException>(){
                private static final long serialVersionUID = 2373163112639943768L;

                @Override
                public String call() throws IOException {
                    File exe = MavenInstallation.this.getExeFile("mvn");
                    if (exe.exists()) {
                        return exe.getPath();
                    }
                    exe = MavenInstallation.this.getExeFile("maven");
                    if (exe.exists()) {
                        return exe.getPath();
                    }
                    return null;
                }
            });
        }

        private File getExeFile(String execName) {
            String m2Home = Util.replaceMacro(this.getHome(), EnvVars.masterEnvVars);
            if (Functions.isWindows()) {
                File exeFile = new File(m2Home, "bin/" + execName + ".bat");
                if (!exeFile.exists()) {
                    return new File(m2Home, "bin/" + execName + ".cmd");
                }
                return exeFile;
            }
            return new File(m2Home, "bin/" + execName);
        }

        public boolean getExists() {
            try {
                return this.getExecutable(new Launcher.LocalLauncher(new StreamTaskListener(new NullStream()))) != null;
            }
            catch (IOException | InterruptedException e) {
                return false;
            }
        }

        @Override
        public MavenInstallation forEnvironment(EnvVars environment) {
            return new MavenInstallation(this.getName(), environment.expand(this.getHome()), this.getProperties().toList());
        }

        @Override
        public MavenInstallation forNode(Node node, TaskListener log) throws IOException, InterruptedException {
            return new MavenInstallation(this.getName(), this.translateFor(node, log), this.getProperties().toList());
        }

        public static class ConverterImpl
        extends ToolInstallation.ToolConverter {
            public ConverterImpl(XStream2 xstream) {
                super(xstream);
            }

            @Override
            protected String oldHomeField(ToolInstallation obj) {
                return ((MavenInstallation)obj).mavenHome;
            }
        }

        @Extension
        @Symbol(value={"maven"})
        public static class DescriptorImpl
        extends ToolDescriptor<MavenInstallation> {
            @Override
            public String getDisplayName() {
                return "Maven";
            }

            @Override
            public List<? extends ToolInstaller> getDefaultInstallers() {
                return Collections.singletonList(new MavenInstaller(null));
            }

            public MavenInstallation[] getInstallations() {
                return Jenkins.getInstance().getDescriptorByType(hudson.tasks.Maven$DescriptorImpl.class).getInstallations();
            }

            public void setInstallations(MavenInstallation ... installations) {
                Jenkins.getInstance().getDescriptorByType(hudson.tasks.Maven$DescriptorImpl.class).setInstallations(installations);
            }

            @Override
            protected FormValidation checkHomeDirectory(File value) {
                File maven1File = new File(value, Maven.MAVEN_1_INSTALLATION_COMMON_FILE);
                File maven2File = new File(value, Maven.MAVEN_2_INSTALLATION_COMMON_FILE);
                if (!maven1File.exists() && !maven2File.exists()) {
                    return FormValidation.error(Messages.Maven_NotMavenDirectory(value));
                }
                return FormValidation.ok();
            }
        }
    }

    @Extension
    @Symbol(value={"maven"})
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private volatile MavenInstallation[] installations = new MavenInstallation[0];

        public DescriptorImpl() {
            DESCRIPTOR = this;
            this.load();
        }

        @Override
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        @Override
        public String getHelpFile(String fieldName) {
            if (fieldName != null && fieldName.equals("globalSettings")) {
                fieldName = "settings";
            }
            return super.getHelpFile(fieldName);
        }

        @Override
        public String getDisplayName() {
            return Messages.Maven_DisplayName();
        }

        public GlobalSettingsProvider getDefaultGlobalSettingsProvider() {
            return GlobalMavenConfig.get().getGlobalSettingsProvider();
        }

        public SettingsProvider getDefaultSettingsProvider() {
            return GlobalMavenConfig.get().getSettingsProvider();
        }

        public MavenInstallation[] getInstallations() {
            return this.installations;
        }

        public void setInstallations(MavenInstallation ... installations) {
            ArrayList tmpList = new ArrayList();
            if (installations != null) {
                Collections.addAll(tmpList, installations);
                for (MavenInstallation installation : installations) {
                    if (Util.fixEmptyAndTrim(installation.getName()) != null) continue;
                    tmpList.remove(installation);
                }
            }
            this.installations = tmpList.toArray(new MavenInstallation[tmpList.size()]);
            this.save();
        }

        @Override
        public Builder newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (Builder)req.bindJSON(Maven.class, formData);
        }
    }

    private static final class DecideDefaultMavenCommand
    extends MasterToSlaveFileCallable<String> {
        private static final long serialVersionUID = -2327576423452215146L;
        private final String arguments;

        public DecideDefaultMavenCommand(String arguments) {
            this.arguments = arguments;
        }

        @Override
        public String invoke(File ws, VirtualChannel channel) throws IOException {
            String seed = null;
            StringTokenizer tokens = new StringTokenizer(this.arguments);
            while (tokens.hasMoreTokens()) {
                File file;
                String t = tokens.nextToken();
                if (!t.equals("-f") || !tokens.hasMoreTokens() || !(file = new File(ws, tokens.nextToken())).exists()) continue;
                seed = file.isDirectory() ? "maven" : "mvn";
                break;
            }
            if (seed == null) {
                seed = new File(ws, "project.xml").exists() ? "maven" : "mvn";
            }
            return seed;
        }
    }
}

