/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.ChannelClosedException;
import hudson.tasks.Builder;
import hudson.tasks.Messages;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

public abstract class CommandInterpreter
extends Builder {
    protected final String command;
    private static final Logger LOGGER = Logger.getLogger(CommandInterpreter.class.getName());

    public CommandInterpreter(String command) {
        this.command = command;
    }

    public final String getCommand() {
        return this.command;
    }

    @Override
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException {
        return this.perform(build, launcher, (TaskListener)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, TaskListener listener) throws InterruptedException {
        FilePath ws = build.getWorkspace();
        if (ws == null) {
            Node node = build.getBuiltOn();
            if (node == null) {
                throw new NullPointerException("no such build node: " + build.getBuiltOnStr());
            }
            throw new NullPointerException("no workspace from node " + node + " which is computer " + node.toComputer() + " and has channel " + node.getChannel());
        }
        FilePath script = null;
        int r = -1;
        try {
            try {
                script = this.createScriptFile(ws);
            }
            catch (IOException e) {
                Util.displayIOException(e, listener);
                e.printStackTrace(listener.fatalError(Messages.CommandInterpreter_UnableToProduceScript()));
                boolean bl = false;
                try {
                    if (script != null) {
                        script.delete();
                    }
                }
                catch (IOException e2) {
                    if (r == -1 && e2.getCause() instanceof ChannelClosedException) {
                        LOGGER.log(Level.FINE, "Script deletion failed", e2);
                    } else {
                        Util.displayIOException(e2, listener);
                        e2.printStackTrace(listener.fatalError(Messages.CommandInterpreter_UnableToDelete(script)));
                    }
                }
                catch (Exception e3) {
                    e3.printStackTrace(listener.fatalError(Messages.CommandInterpreter_UnableToDelete(script)));
                }
                return bl;
            }
            try {
                EnvVars envVars = build.getEnvironment(listener);
                for (Map.Entry<String, String> e : build.getBuildVariables().entrySet()) {
                    envVars.put(e.getKey(), e.getValue());
                }
                r = this.join(launcher.launch().cmds(this.buildCommandLine(script)).envs(envVars).stdout(listener).pwd(ws).start());
            }
            catch (IOException e) {
                Util.displayIOException(e, listener);
                e.printStackTrace(listener.fatalError(Messages.CommandInterpreter_CommandFailed()));
            }
            boolean bl = r == 0;
            return bl;
        }
        finally {
            try {
                if (script != null) {
                    script.delete();
                }
            }
            catch (IOException e) {
                if (r == -1 && e.getCause() instanceof ChannelClosedException) {
                    LOGGER.log(Level.FINE, "Script deletion failed", e);
                } else {
                    Util.displayIOException(e, listener);
                    e.printStackTrace(listener.fatalError(Messages.CommandInterpreter_UnableToDelete(script)));
                }
            }
            catch (Exception e) {
                e.printStackTrace(listener.fatalError(Messages.CommandInterpreter_UnableToDelete(script)));
            }
        }
    }

    protected int join(Proc p) throws IOException, InterruptedException {
        return p.join();
    }

    public FilePath createScriptFile(@Nonnull FilePath dir) throws IOException, InterruptedException {
        return dir.createTextTempFile("hudson", this.getFileExtension(), this.getContents(), false);
    }

    public abstract String[] buildCommandLine(FilePath var1);

    protected abstract String getContents();

    protected abstract String getFileExtension();
}

