/*
 * Decompiled with CFR 0.152.
 */
package hudson.slaves;

import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.PeriodicWork;
import hudson.model.Queue;
import java.util.Map;
import java.util.WeakHashMap;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;

@Extension
@Symbol(value={"computerRetention"})
public class ComputerRetentionWork
extends PeriodicWork {
    private final Map<Computer, Long> nextCheck = new WeakHashMap<Computer, Long>();

    @Override
    public long getRecurrencePeriod() {
        return 60000L;
    }

    @Override
    protected void doRun() {
        final long startRun = System.currentTimeMillis();
        for (final Computer c : Jenkins.getInstance().getComputers()) {
            Queue.withLock(new Runnable(){

                @Override
                public void run() {
                    Node n = c.getNode();
                    if (n != null && n.isHoldOffLaunchUntilSave()) {
                        return;
                    }
                    if (!ComputerRetentionWork.this.nextCheck.containsKey(c) || startRun > (Long)ComputerRetentionWork.this.nextCheck.get(c)) {
                        long waitInMins = Math.max(1L, Math.min(60L, c.getRetentionStrategy().check(c)));
                        ComputerRetentionWork.this.nextCheck.put(c, startRun + waitInMins * 1000L * 60L);
                    }
                }
            });
        }
    }
}

