/*
 * Decompiled with CFR 0.152.
 */
package hudson.security.csrf;

import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.ModelObject;
import hudson.security.csrf.CrumbIssuer;
import hudson.security.csrf.CrumbIssuerDescriptor;
import hudson.security.csrf.Messages;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import jenkins.model.Jenkins;
import jenkins.security.HexStringConfidentialKey;
import jenkins.util.SystemProperties;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class DefaultCrumbIssuer
extends CrumbIssuer {
    private transient MessageDigest md;
    private boolean excludeClientIPFromCrumb;
    private static final String X_FORWARDED_FOR = "X-Forwarded-For";
    private static final Logger LOGGER = Logger.getLogger(DefaultCrumbIssuer.class.getName());

    @DataBoundConstructor
    public DefaultCrumbIssuer(boolean excludeClientIPFromCrumb) {
        try {
            this.md = MessageDigest.getInstance("MD5");
            this.excludeClientIPFromCrumb = excludeClientIPFromCrumb;
        }
        catch (NoSuchAlgorithmException e) {
            this.md = null;
            this.excludeClientIPFromCrumb = false;
            LOGGER.log(Level.SEVERE, "Can't find MD5", e);
        }
    }

    public boolean isExcludeClientIPFromCrumb() {
        return this.excludeClientIPFromCrumb;
    }

    private Object readResolve() {
        try {
            this.md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            this.md = null;
            LOGGER.log(Level.SEVERE, "Can't find MD5", e);
        }
        return this;
    }

    @Override
    protected synchronized String issueCrumb(ServletRequest request, String salt) {
        if (request instanceof HttpServletRequest && this.md != null) {
            HttpServletRequest req = (HttpServletRequest)request;
            StringBuilder buffer = new StringBuilder();
            Authentication a = Jenkins.getAuthentication();
            if (a != null) {
                buffer.append(a.getName());
            }
            buffer.append(';');
            if (!this.isExcludeClientIPFromCrumb()) {
                buffer.append(this.getClientIP(req));
            }
            this.md.update(buffer.toString().getBytes());
            return Util.toHexString(this.md.digest(salt.getBytes()));
        }
        return null;
    }

    @Override
    public boolean validateCrumb(ServletRequest request, String salt, String crumb) {
        String newCrumb;
        if (request instanceof HttpServletRequest && (newCrumb = this.issueCrumb(request, salt)) != null && crumb != null) {
            return MessageDigest.isEqual(newCrumb.getBytes(Charset.forName("US-ASCII")), crumb.getBytes(Charset.forName("US-ASCII")));
        }
        return false;
    }

    private String getClientIP(HttpServletRequest req) {
        String[] hopList;
        String defaultAddress = req.getRemoteAddr();
        String forwarded = req.getHeader(X_FORWARDED_FOR);
        if (forwarded != null && (hopList = forwarded.split(",")).length >= 1) {
            return hopList[0];
        }
        return defaultAddress;
    }

    @Extension
    @Symbol(value={"standard"})
    public static final class DescriptorImpl
    extends CrumbIssuerDescriptor<DefaultCrumbIssuer>
    implements ModelObject {
        private static final HexStringConfidentialKey CRUMB_SALT = new HexStringConfidentialKey(Jenkins.class, "crumbSalt", 16);

        public DescriptorImpl() {
            super(CRUMB_SALT.get(), SystemProperties.getString("hudson.security.csrf.requestfield", "Jenkins-Crumb"));
            this.load();
        }

        @Override
        public String getDisplayName() {
            return Messages.DefaultCrumbIssuer_DisplayName();
        }

        @Override
        public DefaultCrumbIssuer newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (DefaultCrumbIssuer)req.bindJSON(DefaultCrumbIssuer.class, formData);
        }
    }
}

