/*
 * Decompiled with CFR 0.152.
 */
package hudson.security;

import hudson.Functions;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jenkins.model.Jenkins;
import jenkins.security.HMACConfidentialKey;
import jenkins.security.ImpersonatingUserDetailsService;
import org.acegisecurity.Authentication;
import org.acegisecurity.ui.rememberme.TokenBasedRememberMeServices;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UserDetailsService;
import org.apache.commons.codec.binary.Base64;
import org.springframework.util.Assert;

public class TokenBasedRememberMeServices2
extends TokenBasedRememberMeServices {
    private static final HMACConfidentialKey MAC = new HMACConfidentialKey(TokenBasedRememberMeServices.class, "mac");
    private static final Method SET_HTTP_ONLY;

    public void setUserDetailsService(UserDetailsService userDetailsService) {
        super.setUserDetailsService((UserDetailsService)new ImpersonatingUserDetailsService(userDetailsService));
    }

    protected String makeTokenSignature(long tokenExpiryTime, UserDetails userDetails) {
        String expectedTokenSignature = MAC.mac(userDetails.getUsername() + ":" + tokenExpiryTime + ":" + "N/A" + ":" + this.getKey());
        return expectedTokenSignature;
    }

    protected String retrievePassword(Authentication successfulAuthentication) {
        return "N/A";
    }

    public void loginSuccess(HttpServletRequest request, HttpServletResponse response, Authentication successfulAuthentication) {
        if (!this.rememberMeRequested(request, this.getParameter())) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Did not send remember-me cookie (principal did not set parameter '" + this.getParameter() + "')"));
            }
            return;
        }
        Jenkins j = Jenkins.getInstanceOrNull();
        if (j != null && j.isDisableRememberMe()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Did not send remember-me cookie because 'Remember Me' is disabled in security configuration (principal did set parameter '" + this.getParameter() + "')"));
            }
            return;
        }
        Assert.notNull((Object)successfulAuthentication.getPrincipal());
        Assert.notNull((Object)successfulAuthentication.getCredentials());
        Assert.isInstanceOf(UserDetails.class, (Object)successfulAuthentication.getPrincipal());
        long expiryTime = System.currentTimeMillis() + this.tokenValiditySeconds * 1000L;
        String username = ((UserDetails)successfulAuthentication.getPrincipal()).getUsername();
        String signatureValue = this.makeTokenSignature(expiryTime, (UserDetails)successfulAuthentication.getPrincipal());
        String tokenValue = username + ":" + expiryTime + ":" + signatureValue;
        String tokenValueBase64 = new String(Base64.encodeBase64((byte[])tokenValue.getBytes()));
        response.addCookie(this.makeValidCookie(tokenValueBase64, request, this.tokenValiditySeconds));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Added remember-me cookie for user '" + username + "', expiry: '" + new Date(expiryTime) + "'"));
        }
    }

    public Authentication autoLogin(HttpServletRequest request, HttpServletResponse response) {
        try {
            return super.autoLogin(request, response);
        }
        catch (Exception e) {
            this.cancelCookie(request, response, "Failed to handle remember-me cookie: " + Functions.printThrowable(e));
            return null;
        }
    }

    protected Cookie makeValidCookie(String tokenValueBase64, HttpServletRequest request, long maxAge) {
        Cookie cookie = super.makeValidCookie(tokenValueBase64, request, maxAge);
        if (SET_HTTP_ONLY != null) {
            try {
                SET_HTTP_ONLY.invoke((Object)cookie, true);
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
        }
        if (request.isSecure()) {
            cookie.setSecure(true);
        }
        return cookie;
    }

    static {
        Method m = null;
        try {
            m = Cookie.class.getMethod("setHttpOnly", Boolean.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        SET_HTTP_ONLY = m;
    }
}

