/*
 * Decompiled with CFR 0.152.
 */
package hudson.security;

import com.google.common.base.Strings;
import hudson.Functions;
import hudson.security.AccessDeniedException2;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.text.MessageFormat;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.InsufficientAuthenticationException;
import org.acegisecurity.ui.webapp.AuthenticationProcessingFilterEntryPoint;

public class HudsonAuthenticationEntryPoint
extends AuthenticationProcessingFilterEntryPoint {
    public void commence(ServletRequest request, ServletResponse response, AuthenticationException reason) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse rsp = (HttpServletResponse)response;
        String requestedWith = req.getHeader("X-Requested-With");
        if ("XMLHttpRequest".equals(requestedWith)) {
            rsp.sendError(403);
        } else {
            PrintWriter out;
            String uriFrom = req.getRequestURI();
            if (!Strings.isNullOrEmpty((String)req.getQueryString())) {
                uriFrom = uriFrom + "?" + req.getQueryString();
            }
            String loginForm = req.getContextPath() + this.getLoginFormUrl();
            loginForm = MessageFormat.format(loginForm, URLEncoder.encode(uriFrom, "UTF-8"));
            req.setAttribute("loginForm", (Object)loginForm);
            rsp.setStatus(403);
            rsp.setContentType("text/html;charset=UTF-8");
            Functions.advertiseHeaders(rsp);
            AccessDeniedException2 cause = null;
            if (reason instanceof InsufficientAuthenticationException && reason.getCause() instanceof AccessDeniedException2) {
                cause = (AccessDeniedException2)((Object)reason.getCause());
                cause.reportAsHeaders(rsp);
            }
            try {
                out = new PrintWriter(new OutputStreamWriter((OutputStream)rsp.getOutputStream()));
            }
            catch (IllegalStateException e) {
                out = rsp.getWriter();
            }
            out.printf("<html><head><meta http-equiv='refresh' content='1;url=%1$s'/><script>window.location.replace('%1$s');</script></head><body style='background-color:white; color:white;'>\n\n\nAuthentication required\n<!--\n", loginForm);
            if (cause != null) {
                cause.report(out);
            }
            out.printf("-->\n\n</body></html>", new Object[0]);
            for (int i = 0; i < 10; ++i) {
                out.print("                              ");
            }
            out.close();
        }
    }
}

