/*
 * Decompiled with CFR 0.152.
 */
package hudson.security;

import hudson.security.SecurityRealm;
import java.security.Principal;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;

public final class ContainerAuthentication
implements Authentication {
    private final Principal principal;
    private GrantedAuthority[] authorities;

    public ContainerAuthentication(HttpServletRequest request) {
        this.principal = request.getUserPrincipal();
        if (this.principal == null) {
            throw new IllegalStateException();
        }
        ArrayList<Object> l = new ArrayList<Object>();
        for (String g : Jenkins.getInstance().getAuthorizationStrategy().getGroups()) {
            if (!request.isUserInRole(g)) continue;
            l.add(new GrantedAuthorityImpl(g));
        }
        l.add(SecurityRealm.AUTHENTICATED_AUTHORITY);
        this.authorities = l.toArray(new GrantedAuthority[l.size()]);
    }

    public GrantedAuthority[] getAuthorities() {
        return this.authorities;
    }

    public Object getCredentials() {
        return null;
    }

    public Object getDetails() {
        return null;
    }

    public String getPrincipal() {
        return this.principal.getName();
    }

    public boolean isAuthenticated() {
        return true;
    }

    public void setAuthenticated(boolean isAuthenticated) throws IllegalArgumentException {
    }

    public String getName() {
        return this.getPrincipal();
    }
}

