/*
 * Decompiled with CFR 0.152.
 */
package hudson.security;

import hudson.Util;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jenkins.security.SecurityListener;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.ui.webapp.AuthenticationProcessingFilter;

public class AuthenticationProcessingFilter2
extends AuthenticationProcessingFilter {
    private static final Logger LOGGER = Logger.getLogger(AuthenticationProcessingFilter2.class.getName());

    protected String determineTargetUrl(HttpServletRequest request) {
        String targetUrl = request.getParameter("from");
        request.getSession().setAttribute("from", (Object)targetUrl);
        if (targetUrl == null) {
            return this.getDefaultTargetUrl();
        }
        if (!Util.isSafeToRedirectTo(targetUrl)) {
            return ".";
        }
        if (targetUrl.startsWith(request.getContextPath())) {
            return targetUrl.substring(request.getContextPath().length());
        }
        return targetUrl;
    }

    protected String determineFailureUrl(HttpServletRequest request, AuthenticationException failed) {
        Properties excMap = this.getExceptionMappings();
        String failedClassName = ((Object)((Object)failed)).getClass().getName();
        String whereFrom = request.getParameter("from");
        request.getSession().setAttribute("from", (Object)whereFrom);
        return excMap.getProperty(failedClassName, this.getAuthenticationFailureUrl());
    }

    protected void onSuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, Authentication authResult) throws IOException {
        super.onSuccessfulAuthentication(request, response, authResult);
        request.getSession().invalidate();
        request.getSession();
        SecurityListener.fireLoggedIn(authResult.getName());
    }

    protected void onUnsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException failed) throws IOException {
        super.onUnsuccessfulAuthentication(request, response, failed);
        LOGGER.log(Level.FINE, "Login attempt failed", failed);
        Authentication auth = failed.getAuthentication();
        if (auth != null) {
            SecurityListener.fireFailedToLogIn(auth.getName());
        }
    }
}

