/*
 * Decompiled with CFR 0.152.
 */
package hudson.security;

import hudson.security.Messages;
import hudson.security.Permission;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletResponse;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;

public class AccessDeniedException2
extends AccessDeniedException {
    public final Authentication authentication;
    public final Permission permission;

    public AccessDeniedException2(Authentication authentication, Permission permission) {
        this(null, authentication, permission);
    }

    public AccessDeniedException2(Throwable t, Authentication authentication, Permission permission) {
        super(Messages.AccessDeniedException2_MissingPermission(authentication.getName(), permission.group.title + "/" + permission.name), t);
        this.authentication = authentication;
        this.permission = permission;
    }

    public void reportAsHeaders(HttpServletResponse rsp) {
        rsp.addHeader("X-You-Are-Authenticated-As", this.authentication.getName());
        for (GrantedAuthority auth : this.authentication.getAuthorities()) {
            rsp.addHeader("X-You-Are-In-Group", auth.getAuthority());
        }
        rsp.addHeader("X-Required-Permission", this.permission.getId());
        Permission p = this.permission.impliedBy;
        while (p != null) {
            rsp.addHeader("X-Permission-Implied-By", p.getId());
            p = p.impliedBy;
        }
    }

    public void report(PrintWriter w) {
        w.println("You are authenticated as: " + this.authentication.getName());
        w.println("Groups that you are in:");
        for (GrantedAuthority auth : this.authentication.getAuthorities()) {
            w.println("  " + auth.getAuthority());
        }
        w.println("Permission you need to have (but didn't): " + this.permission.getId());
        Permission p = this.permission.impliedBy;
        while (p != null) {
            w.println(" ... which is implied by: " + p.getId());
            p = p.impliedBy;
        }
    }
}

