/*
 * Decompiled with CFR 0.152.
 */
package hudson.search;

import hudson.search.FixedSet;
import hudson.search.ParsedQuickSilver;
import hudson.search.SearchIndex;
import hudson.search.SearchItem;
import hudson.search.SearchItems;
import hudson.search.SearchableModelObject;
import hudson.search.UnionSearchIndex;
import java.util.ArrayList;
import java.util.List;

public final class SearchIndexBuilder {
    private final List<SearchItem> items = new ArrayList<SearchItem>();
    private final List<SearchIndex> indices = new ArrayList<SearchIndex>();

    public SearchIndexBuilder addAllAnnotations(SearchableModelObject o) {
        ParsedQuickSilver.get(o.getClass()).addTo(this, o);
        return this;
    }

    public SearchIndexBuilder add(String urlAsWellAsName) {
        return this.add(urlAsWellAsName, urlAsWellAsName);
    }

    public SearchIndexBuilder add(String url, String name) {
        this.items.add(SearchItems.create(name, url));
        return this;
    }

    public SearchIndexBuilder add(String url, String ... names) {
        for (String name : names) {
            this.add(url, name);
        }
        return this;
    }

    public SearchIndexBuilder add(SearchItem item) {
        this.items.add(item);
        return this;
    }

    public SearchIndexBuilder add(String url, SearchableModelObject searchable, String name) {
        this.items.add(SearchItems.create(name, url, searchable));
        return this;
    }

    public SearchIndexBuilder add(String url, SearchableModelObject searchable, String ... names) {
        for (String name : names) {
            this.add(url, searchable, name);
        }
        return this;
    }

    public SearchIndexBuilder add(SearchIndex index) {
        this.indices.add(index);
        return this;
    }

    public SearchIndexBuilder add(SearchIndexBuilder index) {
        return this.add(index.make());
    }

    public SearchIndex make() {
        SearchIndex r = new FixedSet(this.items);
        for (SearchIndex index : this.indices) {
            r = new UnionSearchIndex(r, index);
        }
        return r;
    }
}

