/*
 * Decompiled with CFR 0.152.
 */
package hudson.search;

import hudson.search.QuickSilver;
import hudson.search.SearchIndex;
import hudson.search.SearchIndexBuilder;
import hudson.search.SearchItem;
import hudson.search.SearchableModelObject;
import java.beans.Introspector;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class ParsedQuickSilver {
    private static final Map<Class, ParsedQuickSilver> TABLE = new HashMap<Class, ParsedQuickSilver>();
    private final List<Getter> getters = new ArrayList<Getter>();

    static synchronized ParsedQuickSilver get(Class<? extends SearchableModelObject> clazz) {
        ParsedQuickSilver pqs = TABLE.get(clazz);
        if (pqs == null) {
            pqs = new ParsedQuickSilver(clazz);
            TABLE.put(clazz, pqs);
        }
        return pqs;
    }

    private ParsedQuickSilver(Class<? extends SearchableModelObject> clazz) {
        QuickSilver qs;
        for (Method method : clazz.getMethods()) {
            qs = method.getAnnotation(QuickSilver.class);
            if (qs == null) continue;
            String url = this.stripGetPrefix(method);
            if (qs.value().length == 0) {
                this.getters.add(new MethodGetter(url, this.splitName(url), method));
                continue;
            }
            for (String name : qs.value()) {
                this.getters.add(new MethodGetter(url, name, method));
            }
        }
        for (AccessibleObject accessibleObject : clazz.getFields()) {
            qs = ((Field)accessibleObject).getAnnotation(QuickSilver.class);
            if (qs == null) continue;
            if (qs.value().length == 0) {
                this.getters.add(new FieldGetter(((Field)accessibleObject).getName(), this.splitName(((Field)accessibleObject).getName()), (Field)accessibleObject));
                continue;
            }
            for (String name : qs.value()) {
                this.getters.add(new FieldGetter(((Field)accessibleObject).getName(), name, (Field)accessibleObject));
            }
        }
    }

    private String splitName(String url) {
        StringBuilder buf = new StringBuilder(url.length() + 5);
        for (String token : url.split("(?<=[a-z])(?=[A-Z])")) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append(Introspector.decapitalize(token));
        }
        return buf.toString();
    }

    private String stripGetPrefix(Method m) {
        String n = m.getName();
        if (n.startsWith("get")) {
            n = Introspector.decapitalize(n.substring(3));
        }
        return n;
    }

    private static IllegalAccessError toError(IllegalAccessException e) {
        IllegalAccessError iae = new IllegalAccessError();
        iae.initCause(e);
        return iae;
    }

    public void addTo(SearchIndexBuilder builder, final Object instance) {
        for (final Getter getter : this.getters) {
            builder.add(new SearchItem(){

                @Override
                public String getSearchName() {
                    return getter.searchName;
                }

                @Override
                public String getSearchUrl() {
                    return getter.url;
                }

                @Override
                public SearchIndex getSearchIndex() {
                    Object child = getter.get(instance);
                    if (child == null) {
                        return SearchIndex.EMPTY;
                    }
                    return ((SearchableModelObject)child).getSearchIndex();
                }
            });
        }
    }

    static final class FieldGetter
    extends Getter {
        private final Field field;

        public FieldGetter(String url, String searchName, Field field) {
            super(url, searchName);
            this.field = field;
        }

        @Override
        Object get(Object obj) {
            try {
                return this.field.get(obj);
            }
            catch (IllegalAccessException e) {
                throw ParsedQuickSilver.toError(e);
            }
        }
    }

    static final class MethodGetter
    extends Getter {
        private final Method method;

        public MethodGetter(String url, String searchName, Method method) {
            super(url, searchName);
            this.method = method;
        }

        @Override
        Object get(Object obj) {
            try {
                return this.method.invoke(obj, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw ParsedQuickSilver.toError(e);
            }
            catch (InvocationTargetException e) {
                Throwable x = e.getTargetException();
                if (x instanceof Error) {
                    throw (Error)x;
                }
                if (x instanceof RuntimeException) {
                    throw (RuntimeException)x;
                }
                throw new Error(e);
            }
        }
    }

    static abstract class Getter {
        final String url;
        final String searchName;

        protected Getter(String url, String searchName) {
            this.url = url;
            this.searchName = searchName;
        }

        abstract Object get(Object var1);
    }
}

