/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import antlr.ANTLRException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Actionable;
import hudson.model.Api;
import hudson.model.Computer;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.LoadStatistics;
import hudson.model.Messages;
import hudson.model.ModelObject;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.TopLevelItem;
import hudson.model.labels.LabelAtom;
import hudson.model.labels.LabelExpression;
import hudson.model.labels.LabelExpressionLexer;
import hudson.model.labels.LabelExpressionParser;
import hudson.model.labels.LabelOperatorPrecedence;
import hudson.model.labels.LabelVisitor;
import hudson.model.queue.SubTask;
import hudson.security.ACL;
import hudson.slaves.Cloud;
import hudson.slaves.NodeProvisioner;
import hudson.util.QuotedStringTokenizer;
import hudson.util.VariableResolver;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import jenkins.model.Jenkins;
import jenkins.model.ModelObjectWithChildren;
import jenkins.model.ModelObjectWithContextMenu;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public abstract class Label
extends Actionable
implements Comparable<Label>,
ModelObjectWithChildren {
    protected final transient String name;
    private volatile transient Set<Node> nodes;
    private volatile transient Set<Cloud> clouds;
    private volatile transient int tiedJobsCount;
    @Exported
    public final transient LoadStatistics loadStatistics;
    public final transient NodeProvisioner nodeProvisioner;
    private static final LabelVisitor<Void, Set<LabelAtom>> ATOM_COLLECTOR = new LabelVisitor<Void, Set<LabelAtom>>(){

        @Override
        public Void onAtom(LabelAtom a, Set<LabelAtom> param) {
            param.add(a);
            return null;
        }

        @Override
        public Void onParen(LabelExpression.Paren p, Set<LabelAtom> param) {
            return p.base.accept(this, param);
        }

        @Override
        public Void onNot(LabelExpression.Not p, Set<LabelAtom> param) {
            return p.base.accept(this, param);
        }

        @Override
        public Void onAnd(LabelExpression.And p, Set<LabelAtom> param) {
            return this.onBinary(p, param);
        }

        @Override
        public Void onOr(LabelExpression.Or p, Set<LabelAtom> param) {
            return this.onBinary(p, param);
        }

        @Override
        public Void onIff(LabelExpression.Iff p, Set<LabelAtom> param) {
            return this.onBinary(p, param);
        }

        @Override
        public Void onImplies(LabelExpression.Implies p, Set<LabelAtom> param) {
            return this.onBinary(p, param);
        }

        private Void onBinary(LabelExpression.Binary b, Set<LabelAtom> param) {
            b.lhs.accept(this, param);
            b.rhs.accept(this, param);
            return null;
        }
    };

    public Label(String name) {
        this.name = name;
        this.loadStatistics = new LoadStatistics(0, 0){

            @Override
            public int computeIdleExecutors() {
                return Label.this.getIdleExecutors();
            }

            @Override
            public int computeTotalExecutors() {
                return Label.this.getTotalExecutors();
            }

            @Override
            public int computeQueueLength() {
                return Jenkins.getInstance().getQueue().countBuildableItemsFor(Label.this);
            }

            protected Set<Node> getNodes() {
                return Label.this.getNodes();
            }

            @Override
            protected boolean matches(Queue.Item item, SubTask subTask) {
                Label l = item.getAssignedLabelFor(subTask);
                return l != null && Label.this.matches(l.name);
            }
        };
        this.nodeProvisioner = new NodeProvisioner(this, this.loadStatistics);
    }

    @Exported
    public final String getName() {
        return this.getDisplayName();
    }

    @Override
    public String getDisplayName() {
        return this.name;
    }

    public abstract String getExpression();

    public String getUrl() {
        return "label/" + this.name + '/';
    }

    @Override
    public String getSearchUrl() {
        return this.getUrl();
    }

    public boolean isAtom() {
        return false;
    }

    public abstract boolean matches(VariableResolver<Boolean> var1);

    public final boolean matches(final Collection<LabelAtom> labels) {
        return this.matches(new VariableResolver<Boolean>(){

            @Override
            public Boolean resolve(String name) {
                for (LabelAtom a : labels) {
                    if (!a.getName().equals(name)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    public final boolean matches(Node n) {
        return this.matches(n.getAssignedLabels());
    }

    public boolean isSelfLabel() {
        Set<Node> nodes = this.getNodes();
        return nodes.size() == 1 && nodes.iterator().next().getSelfLabel() == this;
    }

    @Exported
    public Set<Node> getNodes() {
        Set<Node> nodes = this.nodes;
        if (nodes != null) {
            return nodes;
        }
        HashSet<Node> r = new HashSet<Node>();
        Jenkins h = Jenkins.getInstance();
        if (this.matches(h)) {
            r.add(h);
        }
        for (Node n : h.getNodes()) {
            if (!this.matches(n)) continue;
            r.add(n);
        }
        this.nodes = Collections.unmodifiableSet(r);
        return this.nodes;
    }

    @Exported
    public Set<Cloud> getClouds() {
        if (this.clouds == null) {
            HashSet<Cloud> r = new HashSet<Cloud>();
            Jenkins h = Jenkins.getInstance();
            for (Cloud c : h.clouds) {
                if (!c.canProvision(this)) continue;
                r.add(c);
            }
            this.clouds = Collections.unmodifiableSet(r);
        }
        return this.clouds;
    }

    public boolean isAssignable() {
        for (Node n : this.getNodes()) {
            if (n.getNumExecutors() <= 0) continue;
            return true;
        }
        return !this.getClouds().isEmpty();
    }

    public int getTotalConfiguredExecutors() {
        int r = 0;
        for (Node n : this.getNodes()) {
            r += n.getNumExecutors();
        }
        return r;
    }

    @Exported
    public int getTotalExecutors() {
        int r = 0;
        for (Node n : this.getNodes()) {
            Computer c = n.toComputer();
            if (c == null || !c.isOnline()) continue;
            r += c.countExecutors();
        }
        return r;
    }

    @Exported
    public int getBusyExecutors() {
        int r = 0;
        for (Node n : this.getNodes()) {
            Computer c = n.toComputer();
            if (c == null || !c.isOnline()) continue;
            r += c.countBusy();
        }
        return r;
    }

    @Exported
    public int getIdleExecutors() {
        int r = 0;
        for (Node n : this.getNodes()) {
            Computer c = n.toComputer();
            if (c == null || !c.isOnline() && !c.isConnecting() || !c.isAcceptingTasks()) continue;
            r += c.countIdle();
        }
        return r;
    }

    @Exported
    public boolean isOffline() {
        for (Node n : this.getNodes()) {
            Computer c = n.toComputer();
            if (c == null || c.isOffline()) continue;
            return false;
        }
        return true;
    }

    @Exported
    public String getDescription() {
        Set<Node> nodes = this.getNodes();
        if (nodes.isEmpty()) {
            Set<Cloud> clouds = this.getClouds();
            if (clouds.isEmpty()) {
                return Messages.Label_InvalidLabel();
            }
            return Messages.Label_ProvisionedFrom(this.toString(clouds));
        }
        if (nodes.size() == 1) {
            return nodes.iterator().next().getNodeDescription();
        }
        return Messages.Label_GroupOf(this.toString(nodes));
    }

    private String toString(Collection<? extends ModelObject> model) {
        boolean first = true;
        StringBuilder buf = new StringBuilder();
        for (ModelObject modelObject : model) {
            if (buf.length() > 80) {
                buf.append(",...");
                break;
            }
            if (!first) {
                buf.append(',');
            } else {
                first = false;
            }
            buf.append(modelObject.getDisplayName());
        }
        return buf.toString();
    }

    @Exported
    public List<AbstractProject> getTiedJobs() {
        ArrayList<AbstractProject> r = new ArrayList<AbstractProject>();
        for (AbstractProject p : Jenkins.getInstance().getAllItems(AbstractProject.class)) {
            if (!(p instanceof TopLevelItem) || !this.equals(p.getAssignedLabel())) continue;
            r.add(p);
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTiedJobCount() {
        if (this.tiedJobsCount != -1) {
            return this.tiedJobsCount;
        }
        SecurityContext context = ACL.impersonate(ACL.SYSTEM);
        try {
            int result = 0;
            for (TopLevelItem topLevelItem : Jenkins.getInstance().getItemMap().values()) {
                AbstractProject project;
                if (topLevelItem instanceof AbstractProject && this.matches((project = (AbstractProject)((Object)topLevelItem)).getAssignedLabelString())) {
                    ++result;
                }
                if (!(topLevelItem instanceof ItemGroup)) continue;
                Stack<ItemGroup> q = new Stack<ItemGroup>();
                q.push((ItemGroup)((Object)topLevelItem));
                while (!q.isEmpty()) {
                    ItemGroup parent = (ItemGroup)q.pop();
                    for (Item i : parent.getItems()) {
                        AbstractProject project2;
                        if (i instanceof AbstractProject && this.matches((project2 = (AbstractProject)i).getAssignedLabelString())) {
                            ++result;
                        }
                        if (!(i instanceof ItemGroup)) continue;
                        q.push((ItemGroup)((Object)i));
                    }
                }
            }
            int n = this.tiedJobsCount = result;
            return n;
        }
        finally {
            SecurityContextHolder.setContext((SecurityContext)context);
        }
    }

    public boolean contains(Node node) {
        return this.getNodes().contains(node);
    }

    public boolean isEmpty() {
        return this.getNodes().isEmpty() && this.getClouds().isEmpty();
    }

    void reset() {
        this.nodes = null;
        this.clouds = null;
        this.tiedJobsCount = -1;
    }

    public Api getApi() {
        return new Api(this);
    }

    public abstract <V, P> V accept(LabelVisitor<V, P> var1, P var2);

    public Set<LabelAtom> listAtoms() {
        HashSet<LabelAtom> r = new HashSet<LabelAtom>();
        this.accept(ATOM_COLLECTOR, r);
        return r;
    }

    public Label and(Label rhs) {
        return new LabelExpression.And(this, rhs);
    }

    public Label or(Label rhs) {
        return new LabelExpression.Or(this, rhs);
    }

    public Label iff(Label rhs) {
        return new LabelExpression.Iff(this, rhs);
    }

    public Label implies(Label rhs) {
        return new LabelExpression.Implies(this, rhs);
    }

    public Label not() {
        return new LabelExpression.Not(this);
    }

    public Label paren() {
        return new LabelExpression.Paren(this);
    }

    public abstract LabelOperatorPrecedence precedence();

    public final boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        return this.matches(((Label)that).name);
    }

    public final int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public final int compareTo(Label that) {
        return this.name.compareTo(that.name);
    }

    private final boolean matches(String name) {
        return this.name.equals(name);
    }

    public String toString() {
        return this.name;
    }

    @Override
    public ModelObjectWithContextMenu.ContextMenu doChildrenContextMenu(StaplerRequest request, StaplerResponse response) throws Exception {
        ModelObjectWithContextMenu.ContextMenu menu = new ModelObjectWithContextMenu.ContextMenu();
        for (Node node : this.getNodes()) {
            menu.add(node);
        }
        return menu;
    }

    public static Set<LabelAtom> parse(String labels) {
        TreeSet<LabelAtom> r = new TreeSet<LabelAtom>();
        if ((labels = Util.fixNull(labels)).length() > 0) {
            for (String l : new QuotedStringTokenizer(labels).toArray()) {
                r.add(Jenkins.getInstance().getLabelAtom(l));
            }
        }
        return r;
    }

    public static Label get(String l) {
        return Jenkins.getInstance().getLabel(l);
    }

    public static Label parseExpression(String labelExpression) throws ANTLRException {
        LabelExpressionLexer lexer = new LabelExpressionLexer(new StringReader(labelExpression));
        return new LabelExpressionParser(lexer).expr();
    }

    public static final class ConverterImpl
    implements Converter {
        public boolean canConvert(Class type) {
            return Label.class.isAssignableFrom(type);
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            Label src = (Label)source;
            writer.setValue(src.getExpression());
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            return Jenkins.getInstance().getLabel(reader.getValue());
        }
    }
}

