/*
 * Decompiled with CFR 0.152.
 */
package hudson;

import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.ExtensionPoint;
import hudson.FilePath;
import hudson.FileSystemProvisionerDescriptor;
import hudson.WorkspaceSnapshot;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Describable;
import hudson.model.TaskListener;
import hudson.util.io.ArchiverFactory;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;

public abstract class FileSystemProvisioner
implements ExtensionPoint,
Describable<FileSystemProvisioner> {
    public static final FileSystemProvisioner DEFAULT = new Default();

    public abstract void prepareWorkspace(AbstractBuild<?, ?> var1, FilePath var2, TaskListener var3) throws IOException, InterruptedException;

    public abstract void discardWorkspace(AbstractProject<?, ?> var1, FilePath var2) throws IOException, InterruptedException;

    public abstract WorkspaceSnapshot snapshot(AbstractBuild<?, ?> var1, FilePath var2, String var3, TaskListener var4) throws IOException, InterruptedException;

    public FileSystemProvisionerDescriptor getDescriptor() {
        return (FileSystemProvisionerDescriptor)Jenkins.getInstance().getDescriptorOrDie(this.getClass());
    }

    public static DescriptorExtensionList<FileSystemProvisioner, FileSystemProvisionerDescriptor> all() {
        return Jenkins.getInstance().getDescriptorList(FileSystemProvisioner.class);
    }

    public static final class Default
    extends FileSystemProvisioner {
        @Override
        public void prepareWorkspace(AbstractBuild<?, ?> build, FilePath ws, TaskListener listener) throws IOException, InterruptedException {
        }

        @Override
        public void discardWorkspace(AbstractProject<?, ?> project, FilePath ws) throws IOException, InterruptedException {
        }

        @Deprecated
        public WorkspaceSnapshot snapshot(AbstractBuild<?, ?> build, FilePath ws, TaskListener listener) throws IOException, InterruptedException {
            return this.snapshot(build, ws, "**/*", listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public WorkspaceSnapshot snapshot(AbstractBuild<?, ?> build, FilePath ws, String glob, TaskListener listener) throws IOException, InterruptedException {
            File wss = new File(build.getRootDir(), "workspace.tgz");
            try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(wss));){
                ws.archive(ArchiverFactory.TARGZ, (OutputStream)os, glob);
            }
            return new WorkspaceSnapshotImpl();
        }

        @Extension
        @Symbol(value={"standard"})
        public static final class DescriptorImpl
        extends FileSystemProvisionerDescriptor {
            @Override
            public boolean discard(FilePath ws, TaskListener listener) throws IOException, InterruptedException {
                return false;
            }

            @Override
            public String getDisplayName() {
                return "Default";
            }
        }

        public static final class WorkspaceSnapshotImpl
        extends WorkspaceSnapshot {
            @Override
            public void restoreTo(AbstractBuild<?, ?> owner, FilePath dst, TaskListener listener) throws IOException, InterruptedException {
                File zip = new File(owner.getRootDir(), "workspace.zip");
                if (zip.exists()) {
                    new FilePath(zip).unzip(dst);
                } else {
                    File tgz = new File(owner.getRootDir(), "workspace.tgz");
                    new FilePath(tgz).untar(dst, FilePath.TarCompression.GZIP);
                }
            }
        }
    }
}

