/*
 * Decompiled with CFR 0.152.
 */
package rpc.core;

import java.util.StringTokenizer;
import ndr.NdrBuffer;
import ndr.NdrException;
import ndr.NdrObject;
import ndr.NetworkDataRepresentation;

public class UUID
extends NdrObject {
    public static final String NIL_UUID = "00000000-0000-0000-0000-000000000000";
    private static final int TIMELOW_INDEX = 0;
    private static final int TIMEMID_INDEX = 1;
    private static final int TIMEHIGHANDVERSION_INDEX = 2;
    private static final int CLOCKSEQHIGHANDRESERVED_INDEX = 3;
    private static final int CLOCKSEQLOW_INDEX = 4;
    private static final int NODE_INDEX = 5;
    int timeLow;
    int timeMid;
    int timeHighAndVersion;
    int clockSeqHighAndReserved;
    int clockSeqLow;
    byte[] node = new byte[6];

    public UUID() {
    }

    public UUID(String uuid) {
        this.parse(uuid);
    }

    public void encode(NetworkDataRepresentation ndr, NdrBuffer dst) throws NdrException {
        dst.enc_ndr_long(this.timeLow);
        dst.enc_ndr_short(this.timeMid);
        dst.enc_ndr_short(this.timeHighAndVersion);
        dst.enc_ndr_small(this.clockSeqHighAndReserved);
        dst.enc_ndr_small(this.clockSeqLow);
        System.arraycopy(this.node, 0, dst.buf, dst.index, 6);
        dst.index += 6;
    }

    public void decode(NetworkDataRepresentation ndr, NdrBuffer src) throws NdrException {
        this.timeLow = src.dec_ndr_long();
        this.timeMid = src.dec_ndr_short();
        this.timeHighAndVersion = src.dec_ndr_short();
        this.clockSeqHighAndReserved = src.dec_ndr_small();
        this.clockSeqLow = src.dec_ndr_small();
        System.arraycopy(src.buf, src.index, this.node, 0, 6);
        src.index += 6;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(Integer.toHexString(this.timeLow >> 28 & 0xF));
        buffer.append(Integer.toHexString(this.timeLow >> 24 & 0xF));
        buffer.append(Integer.toHexString(this.timeLow >> 20 & 0xF));
        buffer.append(Integer.toHexString(this.timeLow >> 16 & 0xF));
        buffer.append(Integer.toHexString(this.timeLow >> 12 & 0xF));
        buffer.append(Integer.toHexString(this.timeLow >> 8 & 0xF));
        buffer.append(Integer.toHexString(this.timeLow >> 4 & 0xF));
        buffer.append(Integer.toHexString(this.timeLow & 0xF));
        buffer.append('-');
        buffer.append(Integer.toHexString(this.timeMid >> 12 & 0xF));
        buffer.append(Integer.toHexString(this.timeMid >> 8 & 0xF));
        buffer.append(Integer.toHexString(this.timeMid >> 4 & 0xF));
        buffer.append(Integer.toHexString(this.timeMid & 0xF));
        buffer.append('-');
        buffer.append(Integer.toHexString(this.timeHighAndVersion >> 12 & 0xF));
        buffer.append(Integer.toHexString(this.timeHighAndVersion >> 8 & 0xF));
        buffer.append(Integer.toHexString(this.timeHighAndVersion >> 4 & 0xF));
        buffer.append(Integer.toHexString(this.timeHighAndVersion & 0xF));
        buffer.append('-');
        buffer.append(Integer.toHexString(this.clockSeqHighAndReserved >> 4 & 0xF));
        buffer.append(Integer.toHexString(this.clockSeqHighAndReserved & 0xF));
        buffer.append(Integer.toHexString(this.clockSeqLow >> 4 & 0xF));
        buffer.append(Integer.toHexString(this.clockSeqLow & 0xF));
        buffer.append('-');
        for (int i = 0; i < 6; ++i) {
            buffer.append(Integer.toHexString(this.node[i] >> 4 & 0xF));
            buffer.append(Integer.toHexString(this.node[i] & 0xF));
        }
        return buffer.toString();
    }

    public void parse(String uuid) {
        StringTokenizer tokenizer = new StringTokenizer(uuid, "-");
        this.timeLow = (int)Long.parseLong(tokenizer.nextToken(), 16);
        this.timeMid = Integer.parseInt(tokenizer.nextToken(), 16);
        this.timeHighAndVersion = Integer.parseInt(tokenizer.nextToken(), 16);
        String token = tokenizer.nextToken();
        this.clockSeqHighAndReserved = Integer.parseInt(token.substring(0, 2), 16);
        this.clockSeqLow = Integer.parseInt(token.substring(2), 16);
        token = tokenizer.nextToken();
        this.node = new byte[6];
        for (int i = 0; i < 6; ++i) {
            int offset = i * 2;
            this.node[i] = (byte)(Character.digit(token.charAt(offset), 16) << 4 | Character.digit(token.charAt(offset + 1), 16));
        }
    }
}

