/*
 * Decompiled with CFR 0.152.
 */
package net.java.sezpoz;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.java.sezpoz.IndexError;
import net.java.sezpoz.IndexItem;
import net.java.sezpoz.impl.SerAnnotatedElement;

public final class Index<A extends Annotation, I>
implements Iterable<IndexItem<A, I>> {
    private static final Logger LOGGER = Logger.getLogger(Index.class.getName());
    private final Class<A> annotation;
    private final Class<I> instanceType;
    private final ClassLoader loader;

    public static <A extends Annotation, I> Index<A, I> load(Class<A> annotation, Class<I> instanceType) throws IllegalArgumentException {
        return Index.load(annotation, instanceType, Thread.currentThread().getContextClassLoader());
    }

    public static <A extends Annotation, I> Index<A, I> load(Class<A> annotation, Class<I> instanceType, ClassLoader loader) throws IllegalArgumentException {
        return new Index<A, I>(annotation, instanceType, loader);
    }

    private Index(Class<A> annotation, Class<I> instance, ClassLoader loader) {
        this.annotation = annotation;
        this.instanceType = instance;
        this.loader = loader;
    }

    @Override
    public Iterator<IndexItem<A, I>> iterator() {
        return new LazyIndexIterator();
    }

    private final class LazyIndexIterator
    implements Iterator<IndexItem<A, I>> {
        private Enumeration<URL> resources;
        private ObjectInputStream ois;
        private URL resource;
        private IndexItem<A, I> next;
        private boolean end;
        private final Set<String> loadedMembers = new HashSet<String>();

        public LazyIndexIterator() {
            if (LOGGER.isLoggable(Level.FINE)) {
                String urls = Index.this.loader instanceof URLClassLoader ? " " + Arrays.toString(((URLClassLoader)Index.this.loader).getURLs()) : "";
                LOGGER.log(Level.FINE, "Searching for indices of {0} in {1}{2}", new Object[]{Index.this.annotation, Index.this.loader, urls});
            }
        }

        private void peek() throws IndexError {
            try {
                int iteration = 0;
                while (true) {
                    SerAnnotatedElement el;
                    if (iteration == 9999) {
                        LOGGER.log(Level.WARNING, "possible endless loop getting index for {0} from {1}", new Object[]{Index.this.annotation, Index.this.loader});
                    }
                    if (this.next != null || this.end) {
                        return;
                    }
                    if (this.ois == null) {
                        if (this.resources == null) {
                            this.resources = Index.this.loader.getResources("META-INF/annotations/" + Index.this.annotation.getName());
                        }
                        if (!this.resources.hasMoreElements()) {
                            this.end = true;
                            return;
                        }
                        this.resource = this.resources.nextElement();
                        LOGGER.log(Level.FINE, "Loading index from {0}", this.resource);
                        this.ois = new ObjectInputStream(this.resource.openStream());
                    }
                    if ((el = (SerAnnotatedElement)this.ois.readObject()) == null) {
                        this.ois.close();
                        this.ois = null;
                    } else {
                        String memberName;
                        String string = el.isMethod ? el.className + '#' + el.memberName + "()" : (memberName = el.memberName != null ? el.className + '#' + el.memberName : el.className);
                        if (this.loadedMembers.add(memberName)) {
                            this.next = new IndexItem(el, Index.this.annotation, Index.this.instanceType, Index.this.loader, this.resource);
                            break;
                        }
                        LOGGER.log(Level.FINE, "Already loaded index item {0}", el);
                    }
                    ++iteration;
                }
            }
            catch (Exception x) {
                if (this.ois != null) {
                    try {
                        this.ois.close();
                    }
                    catch (IOException x2) {
                        LOGGER.log(Level.WARNING, null, x2);
                    }
                }
                throw new IndexError(x);
            }
        }

        @Override
        public boolean hasNext() {
            this.peek();
            return !this.end;
        }

        @Override
        public IndexItem<A, I> next() {
            this.peek();
            if (!this.end) {
                assert (this.next != null);
                IndexItem _next = this.next;
                this.next = null;
                return _next;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

