/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.List;
import java.util.Map;
import java.util.Set;
import redis.clients.jedis.BinaryClient;
import redis.clients.jedis.BinaryTransaction;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.Client;
import redis.clients.jedis.Response;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.ZParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transaction
extends BinaryTransaction {
    public Transaction() {
    }

    public Transaction(Client client) {
        super(client);
    }

    public Response<Long> append(String key, String value) {
        this.client.append(key, value);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<List<String>> blpop(String ... args) {
        this.client.blpop(args);
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    public Response<List<String>> brpop(String ... args) {
        this.client.brpop(args);
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    public Response<Long> decr(String key) {
        this.client.decr(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> decrBy(String key, long integer) {
        this.client.decrBy(key, integer);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> del(String ... keys) {
        this.client.del(keys);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<String> echo(String string) {
        this.client.echo(string);
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<Boolean> exists(String key) {
        this.client.exists(key);
        return this.getResponse(BuilderFactory.BOOLEAN);
    }

    public Response<Long> expire(String key, int seconds) {
        this.client.expire(key, seconds);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> expireAt(String key, long unixTime) {
        this.client.expireAt(key, unixTime);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<String> get(String key) {
        this.client.get(key);
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<Boolean> getbit(String key, long offset) {
        this.client.getbit(key, offset);
        return this.getResponse(BuilderFactory.BOOLEAN);
    }

    public Response<String> getrange(String key, long startOffset, long endOffset) {
        this.client.getrange(key, startOffset, endOffset);
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<String> getSet(String key, String value) {
        this.client.getSet(key, value);
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<Long> hdel(String key, String field) {
        this.client.hdel(key, field);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Boolean> hexists(String key, String field) {
        this.client.hexists(key, field);
        return this.getResponse(BuilderFactory.BOOLEAN);
    }

    public Response<String> hget(String key, String field) {
        this.client.hget(key, field);
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<Map<String, String>> hgetAll(String key) {
        this.client.hgetAll(key);
        return this.getResponse(BuilderFactory.STRING_MAP);
    }

    public Response<Long> hincrBy(String key, String field, long value) {
        this.client.hincrBy(key, field, value);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Set<String>> hkeys(String key) {
        this.client.hkeys(key);
        return this.getResponse(BuilderFactory.STRING_SET);
    }

    public Response<Long> hlen(String key) {
        this.client.hlen(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<List<String>> hmget(String key, String ... fields) {
        this.client.hmget(key, fields);
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    public Response<String> hmset(String key, Map<String, String> hash) {
        this.client.hmset(key, hash);
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<Long> hset(String key, String field, String value) {
        this.client.hset(key, field, value);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> hsetnx(String key, String field, String value) {
        this.client.hsetnx(key, field, value);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<List<String>> hvals(String key) {
        this.client.hvals(key);
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    public Response<Long> incr(String key) {
        this.client.incr(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> incrBy(String key, long integer) {
        this.client.incrBy(key, integer);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Set<String>> keys(String pattern) {
        this.client.keys(pattern);
        return this.getResponse(BuilderFactory.STRING_SET);
    }

    public Response<String> lindex(String key, int index) {
        this.client.lindex(key, (long)index);
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<Long> linsert(String key, BinaryClient.LIST_POSITION where, String pivot, String value) {
        this.client.linsert(key, where, pivot, value);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> llen(String key) {
        this.client.llen(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<String> lpop(String key) {
        this.client.lpop(key);
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<Long> lpush(String key, String string) {
        this.client.lpush(key, string);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> lpushx(String key, String string) {
        this.client.lpushx(key, string);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<List<String>> lrange(String key, long start, long end) {
        this.client.lrange(key, start, end);
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    public Response<Long> lrem(String key, long count, String value) {
        this.client.lrem(key, count, value);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<String> lset(String key, long index, String value) {
        this.client.lset(key, index, value);
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<String> ltrim(String key, long start, long end) {
        this.client.ltrim(key, start, end);
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<List<String>> mget(String ... keys) {
        this.client.mget(keys);
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    public Response<Long> move(String key, int dbIndex) {
        this.client.move(key, dbIndex);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<String> mset(String ... keysvalues) {
        this.client.mset(keysvalues);
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<Long> msetnx(String ... keysvalues) {
        this.client.msetnx(keysvalues);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> persist(String key) {
        this.client.persist(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<String> rename(String oldkey, String newkey) {
        this.client.rename(oldkey, newkey);
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<Long> renamenx(String oldkey, String newkey) {
        this.client.renamenx(oldkey, newkey);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<String> rpop(String key) {
        this.client.rpop(key);
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<String> rpoplpush(String srckey, String dstkey) {
        this.client.rpoplpush(srckey, dstkey);
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<Long> rpush(String key, String string) {
        this.client.rpush(key, string);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> rpushx(String key, String string) {
        this.client.rpushx(key, string);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> sadd(String key, String member) {
        this.client.sadd(key, member);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> scard(String key) {
        this.client.scard(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Set<String>> sdiff(String ... keys) {
        this.client.sdiff(keys);
        return this.getResponse(BuilderFactory.STRING_SET);
    }

    public Response<Long> sdiffstore(String dstkey, String ... keys) {
        this.client.sdiffstore(dstkey, keys);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<String> set(String key, String value) {
        this.client.set(key, value);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<Boolean> setbit(String key, long offset, boolean value) {
        this.client.setbit(key, offset, value);
        return this.getResponse(BuilderFactory.BOOLEAN);
    }

    public Response<String> setex(String key, int seconds, String value) {
        this.client.setex(key, seconds, value);
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<Long> setnx(String key, String value) {
        this.client.setnx(key, value);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> setrange(String key, long offset, String value) {
        this.client.setrange(key, offset, value);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Set<String>> sinter(String ... keys) {
        this.client.sinter(keys);
        return this.getResponse(BuilderFactory.STRING_SET);
    }

    public Response<Long> sinterstore(String dstkey, String ... keys) {
        this.client.sinterstore(dstkey, keys);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Boolean> sismember(String key, String member) {
        this.client.sismember(key, member);
        return this.getResponse(BuilderFactory.BOOLEAN);
    }

    public Response<Set<String>> smembers(String key) {
        this.client.smembers(key);
        return this.getResponse(BuilderFactory.STRING_SET);
    }

    public Response<Long> smove(String srckey, String dstkey, String member) {
        this.client.smove(srckey, dstkey, member);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<List<String>> sort(String key) {
        this.client.sort(key);
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    public Response<List<String>> sort(String key, SortingParams sortingParameters) {
        this.client.sort(key, sortingParameters);
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    public Response<List<String>> sort(String key, SortingParams sortingParameters, String dstkey) {
        this.client.sort(key, sortingParameters, dstkey);
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    public Response<List<String>> sort(String key, String dstkey) {
        this.client.sort(key, dstkey);
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    public Response<String> spop(String key) {
        this.client.spop(key);
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<String> srandmember(String key) {
        this.client.srandmember(key);
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<Long> srem(String key, String member) {
        this.client.srem(key, member);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> strlen(String key) {
        this.client.strlen(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<String> substr(String key, int start, int end) {
        this.client.substr(key, start, end);
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<Set<String>> sunion(String ... keys) {
        this.client.sunion(keys);
        return this.getResponse(BuilderFactory.STRING_SET);
    }

    public Response<Long> sunionstore(String dstkey, String ... keys) {
        this.client.sunionstore(dstkey, keys);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> ttl(String key) {
        this.client.ttl(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<String> type(String key) {
        this.client.type(key);
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<Long> zadd(String key, double score, String member) {
        this.client.zadd(key, score, member);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> zcard(String key) {
        this.client.zcard(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> zcount(String key, double min, double max) {
        this.client.zcount(key, min, max);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Double> zincrby(String key, double score, String member) {
        this.client.zincrby(key, score, member);
        return this.getResponse(BuilderFactory.DOUBLE);
    }

    public Response<Long> zinterstore(String dstkey, String ... sets) {
        this.client.zinterstore(dstkey, sets);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> zinterstore(String dstkey, ZParams params, String ... sets) {
        this.client.zinterstore(dstkey, params, sets);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Set<String>> zrange(String key, int start, int end) {
        this.client.zrange(key, (long)start, (long)end);
        return this.getResponse(BuilderFactory.STRING_ZSET);
    }

    public Response<Set<String>> zrangeByScore(String key, double min, double max) {
        this.client.zrangeByScore(key, min, max);
        return this.getResponse(BuilderFactory.STRING_ZSET);
    }

    public Response<Set<String>> zrangeByScore(String key, String min, String max) {
        this.client.zrangeByScore(key, min, max);
        return this.getResponse(BuilderFactory.STRING_ZSET);
    }

    public Response<Set<String>> zrangeByScore(String key, double min, double max, int offset, int count) {
        this.client.zrangeByScore(key, min, max, offset, count);
        return this.getResponse(BuilderFactory.STRING_ZSET);
    }

    public Response<Set<Tuple>> zrangeByScoreWithScores(String key, double min, double max) {
        this.client.zrangeByScoreWithScores(key, min, max);
        return this.getResponse(BuilderFactory.TUPLE_ZSET);
    }

    public Response<Set<Tuple>> zrangeByScoreWithScores(String key, double min, double max, int offset, int count) {
        this.client.zrangeByScoreWithScores(key, min, max, offset, count);
        return this.getResponse(BuilderFactory.TUPLE_ZSET);
    }

    public Response<Set<Tuple>> zrangeWithScores(String key, int start, int end) {
        this.client.zrangeWithScores(key, (long)start, (long)end);
        return this.getResponse(BuilderFactory.TUPLE_ZSET);
    }

    public Response<Long> zrank(String key, String member) {
        this.client.zrank(key, member);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> zrem(String key, String member) {
        this.client.zrem(key, member);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> zremrangeByRank(String key, int start, int end) {
        this.client.zremrangeByRank(key, (long)start, (long)end);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> zremrangeByScore(String key, double start, double end) {
        this.client.zremrangeByScore(key, start, end);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Set<String>> zrevrange(String key, int start, int end) {
        this.client.zrevrange(key, (long)start, (long)end);
        return this.getResponse(BuilderFactory.STRING_ZSET);
    }

    public Response<Set<Tuple>> zrevrangeWithScores(String key, int start, int end) {
        this.client.zrevrangeWithScores(key, (long)start, (long)end);
        return this.getResponse(BuilderFactory.TUPLE_ZSET);
    }

    public Response<Long> zrevrank(String key, String member) {
        this.client.zrevrank(key, member);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Double> zscore(String key, String member) {
        this.client.zscore(key, member);
        return this.getResponse(BuilderFactory.DOUBLE);
    }

    public Response<Long> zunionstore(String dstkey, String ... sets) {
        this.client.zunionstore(dstkey, sets);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> zunionstore(String dstkey, ZParams params, String ... sets) {
        this.client.zunionstore(dstkey, params, sets);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<String> bgrewriteaof() {
        this.client.bgrewriteaof();
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<String> bgsave() {
        this.client.bgsave();
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<String> configGet(String pattern) {
        this.client.configGet(pattern);
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<String> configSet(String parameter, String value) {
        this.client.configSet(parameter, value);
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<String> brpoplpush(String source, String destination, int timeout) {
        this.client.brpoplpush(source, destination, timeout);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> configResetStat() {
        this.client.configResetStat();
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> save() {
        this.client.save();
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<Long> lastsave() {
        this.client.lastsave();
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> publish(String channel, String message) {
        this.client.publish(channel, message);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> publish(byte[] channel, byte[] message) {
        this.client.publish(channel, message);
        return this.getResponse(BuilderFactory.LONG);
    }
}

