/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.io.File;
import java.util.Map;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.transform.ArtifactTransformException;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.DefaultResolvedArtifact;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.transform.TransformationOperation;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.internal.DisplayName;
import org.gradle.internal.component.local.model.ComponentFileArtifactIdentifier;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.IvyArtifactName;

class TransformingArtifactVisitor
implements ArtifactVisitor {
    private final ArtifactVisitor visitor;
    private final AttributeContainerInternal target;
    private final Map<ComponentArtifactIdentifier, TransformationOperation> artifactResults;
    private final Map<File, TransformationOperation> fileResults;

    TransformingArtifactVisitor(ArtifactVisitor visitor, AttributeContainerInternal target, Map<ComponentArtifactIdentifier, TransformationOperation> artifactResults, Map<File, TransformationOperation> fileResults) {
        this.visitor = visitor;
        this.target = target;
        this.artifactResults = artifactResults;
        this.fileResults = fileResults;
    }

    @Override
    public void visitArtifact(DisplayName variantName, AttributeContainer variantAttributes, ResolvableArtifact artifact) {
        TransformationOperation operation = this.artifactResults.get(artifact.getId());
        operation.getResult().ifSuccessfulOrElse(transformedSubject -> {
            ResolvedArtifact sourceArtifact = artifact.toPublicView();
            for (File output : transformedSubject.getFiles()) {
                DefaultIvyArtifactName artifactName = DefaultIvyArtifactName.forFile(output, sourceArtifact.getClassifier());
                ComponentFileArtifactIdentifier newId = new ComponentFileArtifactIdentifier(sourceArtifact.getId().getComponentIdentifier(), artifactName);
                DefaultResolvedArtifact resolvedArtifact = new DefaultResolvedArtifact(sourceArtifact.getModuleVersion().getId(), (IvyArtifactName)artifactName, (ComponentArtifactIdentifier)newId, artifact, output);
                this.visitor.visitArtifact(variantName, (AttributeContainer)this.target, resolvedArtifact);
            }
        }, failure -> this.visitor.visitFailure((Throwable)new ArtifactTransformException(artifact.getId(), (AttributeContainer)this.target, failure)));
    }

    @Override
    public void visitFailure(Throwable failure) {
        this.visitor.visitFailure(failure);
    }

    @Override
    public boolean includeFiles() {
        return this.visitor.includeFiles();
    }

    @Override
    public boolean requireArtifactFiles() {
        return this.visitor.requireArtifactFiles();
    }

    @Override
    public void visitFile(ComponentArtifactIdentifier artifactIdentifier, DisplayName variantName, AttributeContainer variantAttributes, File file) {
        TransformationOperation operation = this.fileResults.get(file);
        operation.getResult().ifSuccessfulOrElse(transformedSubject -> {
            for (File outputFile : transformedSubject.getFiles()) {
                this.visitor.visitFile(new ComponentFileArtifactIdentifier(artifactIdentifier.getComponentIdentifier(), outputFile.getName()), variantName, (AttributeContainer)this.target, outputFile);
            }
        }, failure -> this.visitor.visitFailure((Throwable)new ArtifactTransformException(file, (AttributeContainer)this.target, failure)));
    }
}

