/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.gradle.api.Describable;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.artifacts.dsl.dependencies.ProjectFinder;
import org.gradle.api.internal.artifacts.transform.ArtifactTransformDependencies;
import org.gradle.api.internal.artifacts.transform.ArtifactTransformListener;
import org.gradle.api.internal.artifacts.transform.CachingTransformationWorkspaceProvider;
import org.gradle.api.internal.artifacts.transform.TransformationSubject;
import org.gradle.api.internal.artifacts.transform.TransformationWorkspaceIdentity;
import org.gradle.api.internal.artifacts.transform.TransformationWorkspaceProvider;
import org.gradle.api.internal.artifacts.transform.Transformer;
import org.gradle.api.internal.artifacts.transform.TransformerInvoker;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.internal.CacheableEntity;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.internal.Try;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.change.Change;
import org.gradle.internal.change.ChangeContainer;
import org.gradle.internal.change.ChangeVisitor;
import org.gradle.internal.change.SummarizingChangeContainer;
import org.gradle.internal.classloader.ClassLoaderHierarchyHasher;
import org.gradle.internal.execution.CacheHandler;
import org.gradle.internal.execution.ExecutionOutcome;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.WorkExecutor;
import org.gradle.internal.execution.history.AfterPreviousExecutionState;
import org.gradle.internal.execution.history.ExecutionHistoryStore;
import org.gradle.internal.execution.history.changes.AbstractFingerprintChanges;
import org.gradle.internal.execution.history.changes.ExecutionStateChanges;
import org.gradle.internal.execution.history.changes.InputFileChanges;
import org.gradle.internal.execution.impl.steps.UpToDateResult;
import org.gradle.internal.file.TreeType;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprinter;
import org.gradle.internal.fingerprint.FileCollectionFingerprinterRegistry;
import org.gradle.internal.fingerprint.OutputNormalizer;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshotter;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.snapshot.impl.ImplementationSnapshot;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;
import org.gradle.util.GFileUtils;

public class DefaultTransformerInvoker
implements TransformerInvoker {
    private final FileSystemSnapshotter fileSystemSnapshotter;
    private final WorkExecutor<UpToDateResult> workExecutor;
    private final ArtifactTransformListener artifactTransformListener;
    private final CachingTransformationWorkspaceProvider immutableTransformationWorkspaceProvider;
    private final FileCollectionFactory fileCollectionFactory;
    private final ClassLoaderHierarchyHasher classLoaderHierarchyHasher;
    private final ProjectFinder projectFinder;

    public DefaultTransformerInvoker(WorkExecutor<UpToDateResult> workExecutor, FileSystemSnapshotter fileSystemSnapshotter, ArtifactTransformListener artifactTransformListener, CachingTransformationWorkspaceProvider immutableTransformationWorkspaceProvider, FileCollectionFactory fileCollectionFactory, ClassLoaderHierarchyHasher classLoaderHierarchyHasher, ProjectFinder projectFinder) {
        this.workExecutor = workExecutor;
        this.fileSystemSnapshotter = fileSystemSnapshotter;
        this.artifactTransformListener = artifactTransformListener;
        this.immutableTransformationWorkspaceProvider = immutableTransformationWorkspaceProvider;
        this.fileCollectionFactory = fileCollectionFactory;
        this.classLoaderHierarchyHasher = classLoaderHierarchyHasher;
        this.projectFinder = projectFinder;
    }

    @Override
    public Try<ImmutableList<File>> invoke(Transformer transformer, File inputArtifact, ArtifactTransformDependencies dependencies, TransformationSubject subject, FileCollectionFingerprinterRegistry fingerprinterRegistry) {
        FileCollectionFingerprinter dependencyFingerprinter = fingerprinterRegistry.getFingerprinter(transformer.getInputArtifactDependenciesNormalizer());
        CurrentFileCollectionFingerprint dependenciesFingerprint = dependencies.fingerprint(dependencyFingerprinter);
        ProjectInternal producerProject = this.determineProducerProject(subject);
        CachingTransformationWorkspaceProvider workspaceProvider = this.determineWorkspaceProvider(producerProject);
        FileSystemLocationSnapshot inputArtifactSnapshot = this.fileSystemSnapshotter.snapshot(inputArtifact);
        FileCollectionFingerprinter inputArtifactFingerprinter = fingerprinterRegistry.getFingerprinter(transformer.getInputArtifactNormalizer());
        String normalizedInputPath = inputArtifactFingerprinter.normalizePath(inputArtifactSnapshot);
        TransformationWorkspaceIdentity identity = this.getTransformationIdentity(producerProject, inputArtifactSnapshot, normalizedInputPath, transformer, dependenciesFingerprint);
        return workspaceProvider.withWorkspace(identity, (identityString, workspace) -> this.fireTransformListeners(transformer, subject, () -> {
            ImplementationSnapshot implementationSnapshot = ImplementationSnapshot.of(transformer.getImplementationClass(), (ClassLoaderHierarchyHasher)this.classLoaderHierarchyHasher);
            CurrentFileCollectionFingerprint inputArtifactFingerprint = inputArtifactFingerprinter.fingerprint((Iterable)ImmutableList.of((Object)inputArtifactSnapshot));
            TransformerExecution execution = new TransformerExecution(transformer, implementationSnapshot, workspace, identityString, workspaceProvider.getExecutionHistoryStore(), this.fileCollectionFactory, inputArtifact, inputArtifactFingerprint, dependencies, dependenciesFingerprint, fingerprinterRegistry.getFingerprinter(OutputNormalizer.class));
            UpToDateResult outcome = (UpToDateResult)this.workExecutor.execute((UnitOfWork)execution);
            return execution.getResult(outcome);
        }));
    }

    private TransformationWorkspaceIdentity getTransformationIdentity(@Nullable ProjectInternal project, FileSystemLocationSnapshot inputArtifactSnapshot, String inputArtifactPath, Transformer transformer, CurrentFileCollectionFingerprint dependenciesFingerprint) {
        return project == null ? this.getImmutableTransformationIdentity(inputArtifactPath, inputArtifactSnapshot, transformer, dependenciesFingerprint) : this.getMutableTransformationIdentity(inputArtifactSnapshot, transformer, dependenciesFingerprint);
    }

    private TransformationWorkspaceIdentity getImmutableTransformationIdentity(String inputArtifactPath, FileSystemLocationSnapshot inputArtifactSnapshot, Transformer transformer, CurrentFileCollectionFingerprint dependenciesFingerprint) {
        return new ImmutableTransformationWorkspaceIdentity(inputArtifactPath, inputArtifactSnapshot.getHash(), transformer.getSecondaryInputHash(), dependenciesFingerprint.getHash());
    }

    private TransformationWorkspaceIdentity getMutableTransformationIdentity(FileSystemLocationSnapshot inputArtifactSnapshot, Transformer transformer, CurrentFileCollectionFingerprint dependenciesFingerprint) {
        return new MutableTransformationWorkspaceIdentity(inputArtifactSnapshot.getAbsolutePath(), transformer.getSecondaryInputHash(), dependenciesFingerprint.getHash());
    }

    private CachingTransformationWorkspaceProvider determineWorkspaceProvider(@Nullable ProjectInternal producerProject) {
        if (producerProject == null) {
            return this.immutableTransformationWorkspaceProvider;
        }
        return (CachingTransformationWorkspaceProvider)producerProject.getServices().get(CachingTransformationWorkspaceProvider.class);
    }

    @Nullable
    private ProjectInternal determineProducerProject(TransformationSubject subject) {
        if (!subject.getProducer().isPresent()) {
            return null;
        }
        ProjectComponentIdentifier projectComponentIdentifier = subject.getProducer().get();
        return this.projectFinder.findProject(projectComponentIdentifier.getBuild(), projectComponentIdentifier.getProjectPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Try<ImmutableList<File>> fireTransformListeners(Transformer transformer, TransformationSubject subject, Supplier<Try<ImmutableList<File>>> execution) {
        this.artifactTransformListener.beforeTransformerInvocation((Describable)transformer, (Describable)subject);
        try {
            Try<ImmutableList<File>> try_ = execution.get();
            return try_;
        }
        finally {
            this.artifactTransformListener.afterTransformerInvocation((Describable)transformer, (Describable)subject);
        }
    }

    public static class MutableTransformationWorkspaceIdentity
    implements TransformationWorkspaceIdentity {
        private final String inputArtifactAbsolutePath;
        private final HashCode secondaryInputsHash;
        private final HashCode dependenciesHash;

        public MutableTransformationWorkspaceIdentity(String inputArtifactAbsolutePath, HashCode secondaryInputsHash, HashCode dependenciesHash) {
            this.inputArtifactAbsolutePath = inputArtifactAbsolutePath;
            this.secondaryInputsHash = secondaryInputsHash;
            this.dependenciesHash = dependenciesHash;
        }

        @Override
        public String getIdentity() {
            Hasher hasher = Hashing.newHasher();
            hasher.putString((CharSequence)this.inputArtifactAbsolutePath);
            hasher.putHash(this.secondaryInputsHash);
            hasher.putHash(this.dependenciesHash);
            return hasher.hash().toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MutableTransformationWorkspaceIdentity that = (MutableTransformationWorkspaceIdentity)o;
            if (!this.secondaryInputsHash.equals((Object)that.secondaryInputsHash)) {
                return false;
            }
            if (!this.dependenciesHash.equals((Object)that.dependenciesHash)) {
                return false;
            }
            return this.inputArtifactAbsolutePath.equals(that.inputArtifactAbsolutePath);
        }

        public int hashCode() {
            int result = this.inputArtifactAbsolutePath.hashCode();
            result = 31 * result + this.secondaryInputsHash.hashCode();
            result = 31 * result + this.dependenciesHash.hashCode();
            return result;
        }
    }

    private static class ImmutableTransformationWorkspaceIdentity
    implements TransformationWorkspaceIdentity {
        private final String inputArtifactPath;
        private final HashCode inputArtifactHash;
        private final HashCode secondaryInputHash;
        private final HashCode dependenciesHash;

        public ImmutableTransformationWorkspaceIdentity(String inputArtifactPath, HashCode inputArtifactHash, HashCode secondaryInputHash, HashCode dependenciesHash) {
            this.inputArtifactPath = inputArtifactPath;
            this.inputArtifactHash = inputArtifactHash;
            this.secondaryInputHash = secondaryInputHash;
            this.dependenciesHash = dependenciesHash;
        }

        @Override
        public String getIdentity() {
            Hasher hasher = Hashing.newHasher();
            hasher.putString((CharSequence)this.inputArtifactPath);
            hasher.putHash(this.inputArtifactHash);
            hasher.putHash(this.secondaryInputHash);
            hasher.putHash(this.dependenciesHash);
            return hasher.hash().toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ImmutableTransformationWorkspaceIdentity that = (ImmutableTransformationWorkspaceIdentity)o;
            if (!this.inputArtifactHash.equals((Object)that.inputArtifactHash)) {
                return false;
            }
            if (!this.inputArtifactPath.equals(that.inputArtifactPath)) {
                return false;
            }
            if (!this.secondaryInputHash.equals((Object)that.secondaryInputHash)) {
                return false;
            }
            return this.dependenciesHash.equals((Object)that.dependenciesHash);
        }

        public int hashCode() {
            int result = this.inputArtifactHash.hashCode();
            result = 31 * result + this.secondaryInputHash.hashCode();
            result = 31 * result + this.dependenciesHash.hashCode();
            return result;
        }
    }

    private static class AllOutputFileChanges
    extends AbstractFingerprintChanges {
        public AllOutputFileChanges(ImmutableSortedMap<String, FileCollectionFingerprint> previous, ImmutableSortedMap<String, CurrentFileCollectionFingerprint> current) {
            super(previous, current, "Output");
        }

        public boolean accept(ChangeVisitor visitor) {
            return this.accept(visitor, true);
        }
    }

    private static class TransformerExecution
    implements UnitOfWork {
        private static final String INPUT_ARTIFACT_PROPERTY_NAME = "inputArtifact";
        private static final String DEPENDENCIES_PROPERTY_NAME = "inputArtifactDependencies";
        private static final String SECONDARY_INPUTS_HASH_PROPERTY_NAME = "inputPropertiesHash";
        private static final String OUTPUT_DIRECTORY_PROPERTY_NAME = "outputDirectory";
        private static final String RESULTS_FILE_PROPERTY_NAME = "resultsFile";
        private static final String INPUT_FILE_PATH_PREFIX = "i/";
        private static final String OUTPUT_FILE_PATH_PREFIX = "o/";
        private final Transformer transformer;
        private final ImplementationSnapshot implementationSnapshot;
        private final TransformationWorkspaceProvider.TransformationWorkspace workspace;
        private final File inputArtifact;
        private final String identityString;
        private final ExecutionHistoryStore executionHistoryStore;
        private final FileCollectionFactory fileCollectionFactory;
        private final ArtifactTransformDependencies dependencies;
        private final ImmutableSortedMap<String, ValueSnapshot> inputSnapshots;
        private final ImmutableSortedMap<String, CurrentFileCollectionFingerprint> inputFileFingerprints;
        private final FileCollectionFingerprinter outputFingerprinter;
        private final Timer executionTimer;

        public TransformerExecution(Transformer transformer, ImplementationSnapshot implementationSnapshot, TransformationWorkspaceProvider.TransformationWorkspace workspace, String identityString, ExecutionHistoryStore executionHistoryStore, FileCollectionFactory fileCollectionFactory, File inputArtifact, CurrentFileCollectionFingerprint inputArtifactFingerprint, ArtifactTransformDependencies dependencies, CurrentFileCollectionFingerprint dependenciesFingerprint, FileCollectionFingerprinter outputFingerprinter) {
            this.implementationSnapshot = implementationSnapshot;
            this.fileCollectionFactory = fileCollectionFactory;
            this.inputArtifact = inputArtifact;
            this.transformer = transformer;
            this.workspace = workspace;
            this.identityString = "transform/" + identityString;
            this.executionHistoryStore = executionHistoryStore;
            this.dependencies = dependencies;
            this.inputSnapshots = ImmutableSortedMap.of((Comparable)((Object)SECONDARY_INPUTS_HASH_PROPERTY_NAME), (Object)ImplementationSnapshot.of((String)"secondary inputs", (HashCode)transformer.getSecondaryInputHash()));
            this.inputFileFingerprints = TransformerExecution.createInputFileFingerprints(inputArtifactFingerprint, dependenciesFingerprint);
            this.outputFingerprinter = outputFingerprinter;
            this.executionTimer = Time.startTimer();
        }

        private static ImmutableSortedMap<String, CurrentFileCollectionFingerprint> createInputFileFingerprints(CurrentFileCollectionFingerprint inputArtifactFingerprint, CurrentFileCollectionFingerprint dependenciesFingerprint) {
            ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
            builder.put((Object)INPUT_ARTIFACT_PROPERTY_NAME, (Object)inputArtifactFingerprint);
            builder.put((Object)DEPENDENCIES_PROPERTY_NAME, (Object)dependenciesFingerprint);
            return builder.build();
        }

        public ExecutionOutcome execute() {
            File outputDir = this.workspace.getOutputDirectory();
            File resultsFile = this.workspace.getResultsFile();
            GFileUtils.cleanDirectory((File)outputDir);
            GFileUtils.deleteFileQuietly((File)resultsFile);
            ImmutableList<File> result = this.transformer.transform(this.inputArtifact, outputDir, this.dependencies);
            this.writeResultsFile(outputDir, resultsFile, result);
            return ExecutionOutcome.EXECUTED;
        }

        private void writeResultsFile(File outputDir, File resultsFile, ImmutableList<File> result) {
            String outputDirPrefix = outputDir.getPath() + File.separator;
            String inputFilePrefix = this.inputArtifact.getPath() + File.separator;
            Stream<String> relativePaths = result.stream().map(file -> {
                if (file.equals(outputDir)) {
                    return OUTPUT_FILE_PATH_PREFIX;
                }
                if (file.equals(this.inputArtifact)) {
                    return INPUT_FILE_PATH_PREFIX;
                }
                String absolutePath = file.getAbsolutePath();
                if (absolutePath.startsWith(outputDirPrefix)) {
                    return OUTPUT_FILE_PATH_PREFIX + RelativePath.parse((boolean)true, (String)absolutePath.substring(outputDirPrefix.length())).getPathString();
                }
                if (absolutePath.startsWith(inputFilePrefix)) {
                    return INPUT_FILE_PATH_PREFIX + RelativePath.parse((boolean)true, (String)absolutePath.substring(inputFilePrefix.length())).getPathString();
                }
                throw new IllegalStateException("Invalid result path: " + absolutePath);
            });
            UncheckedException.callUnchecked(() -> Files.write(resultsFile.toPath(), relativePaths::iterator, new OpenOption[0]));
        }

        private Try<ImmutableList<File>> getResult(UpToDateResult result) {
            return result.getOutcome().map(outcome -> this.loadResultsFile());
        }

        private ImmutableList<File> loadResultsFile() {
            Path transformerResultsPath = this.workspace.getResultsFile().toPath();
            try {
                ImmutableList.Builder builder = ImmutableList.builder();
                List<String> paths = Files.readAllLines(transformerResultsPath, StandardCharsets.UTF_8);
                for (String path : paths) {
                    if (path.startsWith(OUTPUT_FILE_PATH_PREFIX)) {
                        builder.add((Object)new File(this.workspace.getOutputDirectory(), path.substring(2)));
                        continue;
                    }
                    if (path.startsWith(INPUT_FILE_PATH_PREFIX)) {
                        builder.add((Object)new File(this.inputArtifact, path.substring(2)));
                        continue;
                    }
                    throw new IllegalStateException("Cannot parse result path string: " + path);
                }
                return builder.build();
            }
            catch (IOException e) {
                throw new UncheckedIOException((Throwable)e);
            }
        }

        public Optional<Duration> getTimeout() {
            return Optional.empty();
        }

        public void visitOutputProperties(UnitOfWork.OutputPropertyVisitor visitor) {
            visitor.visitOutputProperty(OUTPUT_DIRECTORY_PROPERTY_NAME, TreeType.DIRECTORY, (FileCollection)this.fileCollectionFactory.fixed(new File[]{this.workspace.getOutputDirectory()}));
            visitor.visitOutputProperty(RESULTS_FILE_PROPERTY_NAME, TreeType.FILE, (FileCollection)this.fileCollectionFactory.fixed(new File[]{this.workspace.getResultsFile()}));
        }

        public long markExecutionTime() {
            return this.executionTimer.getElapsedMillis();
        }

        public void visitLocalState(CacheableEntity.LocalStateVisitor visitor) {
        }

        public void outputsRemovedAfterFailureToLoadFromCache() {
        }

        public CacheHandler createCacheHandler() {
            Hasher hasher = Hashing.newHasher();
            for (Map.Entry entry : this.inputSnapshots.entrySet()) {
                hasher.putString((CharSequence)entry.getKey());
                ((ValueSnapshot)entry.getValue()).appendToHasher(hasher);
            }
            for (Map.Entry entry : this.inputFileFingerprints.entrySet()) {
                hasher.putString((CharSequence)entry.getKey());
                hasher.putHash(((CurrentFileCollectionFingerprint)entry.getValue()).getHash());
            }
            final TransformerExecutionBuildCacheKey cacheKey = new TransformerExecutionBuildCacheKey(hasher.hash());
            return new CacheHandler(){

                public <T> Optional<T> load(Function<BuildCacheKey, T> loader) {
                    if (!transformer.isCacheable()) {
                        return Optional.empty();
                    }
                    return Optional.ofNullable(loader.apply(cacheKey));
                }

                public void store(Consumer<BuildCacheKey> storer) {
                    if (transformer.isCacheable()) {
                        storer.accept(cacheKey);
                    }
                }
            };
        }

        public void persistResult(ImmutableSortedMap<String, CurrentFileCollectionFingerprint> finalOutputs, boolean successful, OriginMetadata originMetadata) {
            if (successful) {
                this.executionHistoryStore.store(this.identityString, originMetadata, this.implementationSnapshot, ImmutableList.of(), this.inputSnapshots, this.inputFileFingerprints, finalOutputs, successful);
            }
        }

        public Optional<ExecutionStateChanges> getChangesSincePreviousExecution() {
            return this.executionHistoryStore.load(this.identityString).map(previous -> {
                ImmutableSortedMap<String, CurrentFileCollectionFingerprint> outputsBeforeExecution = this.snapshotOutputs();
                InputFileChanges inputFileChanges = new InputFileChanges(previous.getInputFileProperties(), this.inputFileFingerprints);
                AllOutputFileChanges outputFileChanges = new AllOutputFileChanges((ImmutableSortedMap<String, FileCollectionFingerprint>)previous.getOutputFileProperties(), outputsBeforeExecution);
                return new TransformerExecutionStateChanges(inputFileChanges, outputFileChanges, (AfterPreviousExecutionState)previous);
            });
        }

        public Optional<? extends Iterable<String>> getChangingOutputs() {
            return Optional.of(ImmutableList.of((Object)this.workspace.getOutputDirectory().getAbsolutePath(), (Object)this.workspace.getResultsFile().getAbsolutePath()));
        }

        public ImmutableSortedMap<String, CurrentFileCollectionFingerprint> snapshotAfterOutputsGenerated() {
            return this.snapshotOutputs();
        }

        private ImmutableSortedMap<String, CurrentFileCollectionFingerprint> snapshotOutputs() {
            CurrentFileCollectionFingerprint outputFingerprint = this.outputFingerprinter.fingerprint((FileCollection)this.fileCollectionFactory.fixed(new File[]{this.workspace.getOutputDirectory()}));
            CurrentFileCollectionFingerprint resultsFileFingerprint = this.outputFingerprinter.fingerprint((FileCollection)this.fileCollectionFactory.fixed(new File[]{this.workspace.getResultsFile()}));
            return ImmutableSortedMap.of((Comparable)((Object)OUTPUT_DIRECTORY_PROPERTY_NAME), (Object)outputFingerprint, (Comparable)((Object)RESULTS_FILE_PROPERTY_NAME), (Object)resultsFileFingerprint);
        }

        public String getIdentity() {
            return this.identityString;
        }

        public void visitOutputTrees(CacheableEntity.CacheableTreeVisitor visitor) {
            visitor.visitOutputTree(OUTPUT_DIRECTORY_PROPERTY_NAME, TreeType.DIRECTORY, this.workspace.getOutputDirectory());
            visitor.visitOutputTree(RESULTS_FILE_PROPERTY_NAME, TreeType.FILE, this.workspace.getResultsFile());
        }

        public String getDisplayName() {
            return this.transformer.getDisplayName() + ": " + this.inputArtifact;
        }

        private class TransformerExecutionBuildCacheKey
        implements BuildCacheKey {
            private final HashCode hashCode;

            public TransformerExecutionBuildCacheKey(HashCode hashCode) {
                this.hashCode = hashCode;
            }

            public String getHashCode() {
                return this.hashCode.toString();
            }

            public String getDisplayName() {
                return this.getHashCode() + " for transformer " + TransformerExecution.this.getDisplayName();
            }
        }

        private class TransformerExecutionStateChanges
        implements ExecutionStateChanges {
            private final InputFileChanges inputFileChanges;
            private final AllOutputFileChanges outputFileChanges;
            private final AfterPreviousExecutionState afterPreviousExecutionState;

            public TransformerExecutionStateChanges(InputFileChanges inputFileChanges, AllOutputFileChanges outputFileChanges, AfterPreviousExecutionState afterPreviousExecutionState) {
                this.inputFileChanges = inputFileChanges;
                this.outputFileChanges = outputFileChanges;
                this.afterPreviousExecutionState = afterPreviousExecutionState;
            }

            public Iterable<Change> getInputFilesChanges() {
                return ImmutableList.of();
            }

            public void visitAllChanges(ChangeVisitor visitor) {
                new SummarizingChangeContainer(new ChangeContainer[]{this.inputFileChanges, this.outputFileChanges}).accept(visitor);
            }

            public boolean isRebuildRequired() {
                return true;
            }

            public AfterPreviousExecutionState getPreviousExecution() {
                return this.afterPreviousExecutionState;
            }
        }
    }
}

