/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.internal.toolchain;

import java.io.File;
import org.gradle.api.internal.tasks.compile.BaseForkOptionsConverter;
import org.gradle.api.internal.tasks.compile.daemon.AbstractDaemonCompiler;
import org.gradle.api.tasks.compile.BaseForkOptions;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.play.internal.spec.PlayCompileSpec;
import org.gradle.process.JavaForkOptions;
import org.gradle.process.internal.JavaForkOptionsFactory;
import org.gradle.workers.internal.DaemonForkOptions;
import org.gradle.workers.internal.DaemonForkOptionsBuilder;
import org.gradle.workers.internal.KeepAliveMode;
import org.gradle.workers.internal.WorkerDaemonFactory;
import org.gradle.workers.internal.WorkerFactory;

public class DaemonPlayCompiler<T extends PlayCompileSpec>
extends AbstractDaemonCompiler<T> {
    private final Iterable<File> compilerClasspath;
    private final Iterable<String> classLoaderPackages;
    private final JavaForkOptionsFactory forkOptionsFactory;
    private final File daemonWorkingDir;

    public DaemonPlayCompiler(File daemonWorkingDir, Compiler<T> compiler, WorkerDaemonFactory workerDaemonFactory, Iterable<File> compilerClasspath, Iterable<String> classLoaderPackages, JavaForkOptionsFactory forkOptionsFactory) {
        super(compiler, (WorkerFactory)workerDaemonFactory);
        this.compilerClasspath = compilerClasspath;
        this.classLoaderPackages = classLoaderPackages;
        this.forkOptionsFactory = forkOptionsFactory;
        this.daemonWorkingDir = daemonWorkingDir;
    }

    protected DaemonForkOptions toDaemonForkOptions(PlayCompileSpec spec) {
        BaseForkOptions forkOptions = spec.getForkOptions();
        JavaForkOptions javaForkOptions = new BaseForkOptionsConverter(this.forkOptionsFactory).transform(forkOptions);
        javaForkOptions.setWorkingDir(this.daemonWorkingDir);
        return new DaemonForkOptionsBuilder(this.forkOptionsFactory).javaForkOptions(javaForkOptions).classpath(this.compilerClasspath).sharedPackages(this.classLoaderPackages).keepAliveMode(KeepAliveMode.SESSION).build();
    }
}

