/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.instantiation;

import java.lang.annotation.Annotation;
import java.util.Set;
import org.gradle.internal.instantiation.ConstructorSelector;
import org.gradle.internal.instantiation.DependencyInjectingInstantiator;
import org.gradle.internal.instantiation.InstanceFactory;
import org.gradle.internal.instantiation.InstantiationScheme;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.ServiceLookup;
import org.gradle.internal.service.ServiceRegistry;

class DefaultInstantiationScheme
implements InstantiationScheme {
    private final DependencyInjectingInstantiator instantiator;
    private final ConstructorSelector constructorSelector;
    private final Set<Class<? extends Annotation>> injectionAnnotations;

    public DefaultInstantiationScheme(ConstructorSelector constructorSelector, ServiceRegistry defaultServices, Set<Class<? extends Annotation>> injectionAnnotations) {
        this.constructorSelector = constructorSelector;
        this.injectionAnnotations = injectionAnnotations;
        this.instantiator = new DependencyInjectingInstantiator(constructorSelector, (ServiceLookup)defaultServices);
    }

    @Override
    public Set<Class<? extends Annotation>> getInjectionAnnotations() {
        return this.injectionAnnotations;
    }

    @Override
    public <T> InstanceFactory<T> forType(Class<T> type) {
        return this.instantiator.factoryFor(type);
    }

    @Override
    public Instantiator withServices(ServiceLookup services) {
        return new DependencyInjectingInstantiator(this.constructorSelector, services);
    }

    @Override
    public Instantiator instantiator() {
        return this.instantiator;
    }
}

