/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.internal.tasks.properties.DefaultPropertyWalker;
import org.gradle.api.internal.tasks.properties.DefaultTypeMetadataStore;
import org.gradle.api.internal.tasks.properties.InspectionScheme;
import org.gradle.api.internal.tasks.properties.PropertyWalker;
import org.gradle.api.internal.tasks.properties.TypeMetadataStore;
import org.gradle.api.internal.tasks.properties.annotations.NoOpPropertyAnnotationHandler;
import org.gradle.api.internal.tasks.properties.annotations.PropertyAnnotationHandler;
import org.gradle.api.internal.tasks.properties.annotations.TypeAnnotationHandler;
import org.gradle.cache.internal.CrossBuildInMemoryCacheFactory;
import org.gradle.internal.instantiation.InstantiationScheme;

public class InspectionSchemeFactory {
    private final Map<Class<? extends Annotation>, PropertyAnnotationHandler> allKnownPropertyHandlers;
    private final ImmutableList<TypeAnnotationHandler> allKnownTypeHandlers;
    private final CrossBuildInMemoryCacheFactory cacheFactory;

    public InspectionSchemeFactory(List<? extends PropertyAnnotationHandler> allKnownPropertyHandlers, List<? extends TypeAnnotationHandler> allKnownTypeHandlers, CrossBuildInMemoryCacheFactory cacheFactory) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (PropertyAnnotationHandler propertyAnnotationHandler : allKnownPropertyHandlers) {
            builder.put(propertyAnnotationHandler.getAnnotationType(), (Object)propertyAnnotationHandler);
        }
        this.allKnownPropertyHandlers = builder.build();
        this.allKnownTypeHandlers = ImmutableList.copyOf(allKnownTypeHandlers);
        this.cacheFactory = cacheFactory;
    }

    public InspectionScheme inspectionScheme(Collection<Class<? extends Annotation>> annotations, InstantiationScheme instantiationScheme) {
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)annotations.size());
        for (Class<? extends Annotation> annotation : annotations) {
            PropertyAnnotationHandler handler = this.allKnownPropertyHandlers.get(annotation);
            if (handler == null) {
                throw new IllegalArgumentException(String.format("Annotation @%s is not a registered annotation.", annotation.getSimpleName()));
            }
            builder.add((Object)handler);
        }
        for (Class<? extends Annotation> annotation : instantiationScheme.getInjectionAnnotations()) {
            if (annotations.contains(annotation)) continue;
            builder.add((Object)new NoOpPropertyAnnotationHandler(annotation));
        }
        ImmutableList annotationHandlers = builder.build();
        ImmutableSet.Builder otherAnnotations = ImmutableSet.builderWithExpectedSize((int)(this.allKnownPropertyHandlers.size() - annotations.size()));
        for (Class<? extends Annotation> annotation : this.allKnownPropertyHandlers.keySet()) {
            if (annotations.contains(annotation)) continue;
            otherAnnotations.add(annotation);
        }
        return new InspectionSchemeImpl((List<PropertyAnnotationHandler>)annotationHandlers, (Set<Class<? extends Annotation>>)otherAnnotations.build(), (List<TypeAnnotationHandler>)this.allKnownTypeHandlers, this.cacheFactory);
    }

    private static class InspectionSchemeImpl
    implements InspectionScheme {
        private final DefaultPropertyWalker propertyWalker;
        private final DefaultTypeMetadataStore metadataStore;

        public InspectionSchemeImpl(List<PropertyAnnotationHandler> annotationHandlers, Set<Class<? extends Annotation>> otherKnownAnnotations, List<TypeAnnotationHandler> typeHandlers, CrossBuildInMemoryCacheFactory cacheFactory) {
            this.metadataStore = new DefaultTypeMetadataStore(annotationHandlers, otherKnownAnnotations, typeHandlers, cacheFactory);
            this.propertyWalker = new DefaultPropertyWalker(this.metadataStore);
        }

        @Override
        public TypeMetadataStore getMetadataStore() {
            return this.metadataStore;
        }

        @Override
        public PropertyWalker getPropertyWalker() {
            return this.propertyWalker;
        }
    }
}

